% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sink_all.R
\name{sink_all}
\alias{sink_all}
\title{Divert Message And Output Stream to File}
\usage{
sink_all(path, code)
}
\arguments{
\item{path}{The path of the file to divert to.}

\item{code}{The code to be executed.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \code{\link{NULL}}.
}
\description{
All output and messages up to the first error, for example thrown by
\code{\link{stop}}.
}
\examples{
sink_path  <- file.path(tempdir(), "sink_all.txt")
sink_all(sink_path, {
         print("some output")
         warning("a warning")
         message("a message")
         print("some more output")
})
cat(readLines(sink_path), sep = "\n")
}
