% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reweight.R
\name{reweight}
\alias{reweight}
\title{Reweight}
\usage{
reweight(protected, y)
}
\arguments{
\item{protected}{factor, protected variables with subgroups as levels (sensitive attributes)}

\item{y}{numeric, vector with classes 0 and 1, where 1 means favorable class.}
}
\value{
numeric, vector of weights
}
\description{
Function returns weights for model training. The purpose of this weights is to mitigate bias in statistical parity.
In fact this could potentially worsen the overall performance in other fairness metrics. This affects also model's performance metrics (accuracy).
}
\details{
Method produces weights for each subgroup for each class. Firstly assumes that protected variable and class are independent and
calculates expected probability of this certain event (that subgroup == a and class = c). Than it calculates the actual probability of this event based
on empirical data. Finally the weight is quotient of those probabilities
}
\examples{
data("german")

data <- german
data$Age <- as.factor(ifelse(data$Age <= 25, "young", "old"))
data$Risk <- as.numeric(data$Risk) -1

# training 2 models
weights <- reweight(protected = data$Age, y = data$Risk)

gbm_model          <- gbm::gbm(Risk ~. , data = data)
gbm_model_weighted <- gbm::gbm(Risk ~. , data = data, weights = weights)

gbm_explainer          <- DALEX::explain(gbm_model, data = data[,-1], y = data$Risk)
gbm_weighted_explainer <- DALEX::explain(gbm_model_weighted, data = data[,-1], y = data$Risk)

fobject <- fairness_check(gbm_explainer, gbm_weighted_explainer,
                          protected = data$Age,
                          privileged = "old",
                          label = c("original","weighted"))
# fairness check
fobject
plot(fobject)

# radar
plot(fairness_radar(fobject))
}
\references{
This method was implemented based on Kamiran, Calders 2011 \url{https://link.springer.com/content/pdf/10.1007/s10115-011-0463-8.pdf}
}
