% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fairness.R
\name{eval_cond_stats_parity}
\alias{eval_cond_stats_parity}
\title{Examine Conditional Statistical Parity of a Model}
\usage{
eval_cond_stats_parity(
  data,
  outcome,
  group,
  group2,
  condition,
  probs,
  confint = TRUE,
  cutoff = 0.5,
  bootstraps = 2500,
  alpha = 0.05,
  message = TRUE,
  digits = 2
)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
sensitive attribute}

\item{outcome}{Name of the outcome variable, it must be binary}

\item{group}{Name of the sensitive attribute}

\item{group2}{Name of the group to condition on}

\item{condition}{If the conditional group is categorical, the condition
supplied must be a character of the levels to condition on. If the conditional
group is continuous, the conditions supplied must be a character containing
the sign of the condition and the value to threshold the continuous variable
(e.g. "<50", ">50", "<=50", ">=50").}

\item{probs}{Name of the predicted outcome variable}

\item{confint}{Whether to compute 95\% confidence interval, default is TRUE}

\item{cutoff}{Threshold for the predicted outcome, default is 0.5}

\item{bootstraps}{Number of bootstrap samples, default is 2500}

\item{alpha}{The 1 - significance level for the confidence interval, default is 0.05}

\item{message}{Whether to print the results, default is TRUE}

\item{digits}{Number of digits to round the results to, default is 2}
}
\value{
A list containing the following elements:
\itemize{
\item Conditions: The conditions used to calculate the conditional PPR
\item PPR_Group1: Positive Prediction Rate for the first group
\item PPR_Group2: Positive Prediction Rate for the second group
\item PPR_Diff: Difference in Positive Prediction Rate
\item PPR_Ratio: Ratio in Positive Prediction Rate
If confidence intervals are computed (\code{confint = TRUE}):
\item PPR_Diff_CI: A vector of length 2 containing the lower and upper bounds
of the 95\% confidence interval for the difference in Positive Prediction
Rate
\item PPR_Ratio_CI: A vector of length 2 containing the lower and upper bounds
of the 95\% confidence interval for the ratio in Positive Prediction
Rate
}
}
\description{
This function evaluates \emph{conditional statistical parity}, which measures fairness by comparing positive prediction rates across sensitive groups within a defined subgroup of the population. This is useful in scenarios where fairness should be evaluated in a more context-specific way—e.g., within a particular hospital unit or age bracket. Conditional statistical parity is a refinement of standard statistical parity. Instead of comparing prediction rates across groups in the entire dataset, it restricts the comparison
to a specified subset of the population, defined by a conditioning variable.
}
\details{
The function supports both categorical and continuous conditioning variables. For continuous variables, you can supply a threshold expression like \code{"<50"} or \code{">=75"} to the \code{condition} parameter.
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female")) \%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the sensitive attribute and day_28_flg as the outcome.
# We choose threshold = 0.41 so that the overall FPR is around 5\%.

# Evaluate Conditional Statistical Parity

eval_cond_stats_parity(
  data = test_data,
  outcome = "day_28_flg",
  group = "gender",
  group2 = "service_unit",
  condition = "MICU",
  probs = "pred",
  cutoff = 0.41
)
}
}
\seealso{
\code{\link{eval_stats_parity}}
}
