% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{glance.TSLM}
\alias{glance.TSLM}
\title{Glance a TSLM}
\usage{
\method{glance}{TSLM}(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A one row tibble summarising the model's fit.
}
\description{
Construct a single row summary of the TSLM model.
}
\details{
Contains the R squared (\code{r_squared}), variance of residuals (\code{sigma2}),
the log-likelihood (\code{log_lik}), and information criterion (\code{AIC}, \code{AICc}, \code{BIC}).
}
\examples{
as_tsibble(USAccDeaths) \%>\% 
  model(lm = TSLM(log(value) ~ trend() + season())) \%>\% 
  glance()

}
