% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carpetplot.R
\name{carpetplot_stack}
\alias{carpetplot_stack}
\title{Stacked carpetplot}
\usage{
carpetplot_stack(
  x_list,
  center = TRUE,
  scale = FALSE,
  qcut = 0.1,
  match_scale = TRUE,
  nsep = 0,
  ...
)
}
\arguments{
\item{x_list}{List of data matrices}

\item{center, scale}{Center and scale the data? If \code{x} is fMRI data
which has not otherwise been centered or scaled, it is recommended to center
but not scale it (default).}

\item{qcut}{Sets blackpoint at the \code{qcut} quantile, and the
whitepoint at the \code{1-qcut} quantile. Default: \code{.1}. This is
equivalent to setting the color range between the 10\% and 90\% quantiles.
The quantiles are computed across the entire data matrix after any
centering or scaling.

Must be between 0 and .49. If \code{0} or \code{NULL} (default), do not
clamp the data values.}

\item{match_scale}{Match the scales of the carpetplots? Default: \code{TRUE}.}

\item{nsep}{Equivalent number of data locations for size of gap between
carpetplots. Default: zero (no gap).}

\item{...}{Additional arguments to \code{carpetplot}}
}
\value{
\code{NULL}, invisibly
}
\description{
Stacks carpetplots on top of one another by rbinding the matrices.
}
