% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram_plot.R
\name{histogram_plot}
\alias{histogram_plot}
\title{histogram_plot}
\usage{
histogram_plot(
  data,
  x,
  y = "..count..",
  group = NULL,
  facet_x = NULL,
  facet_y = NULL,
  palette = ez_col,
  position = "stack",
  bins = 30,
  alpha = 0.5,
  facet_scales = "fixed",
  facet_ncol = NULL,
  legend_ncol = NULL,
  env = parent.frame()
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y}{A named character value. Evaluates to a column.}

\item{group}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{palette}{Colour function.}

\item{position}{Either \code{"stack"} (default) or \code{"fill"}}

\item{bins}{number of bins}

\item{alpha}{fill alpha}

\item{facet_scales}{Option passed to scales argument in \code{facet_wrap} or
\code{facet_grid}. Default is \code{"fixed"}.}

\item{facet_ncol}{Option passed to ncol argument in \code{facet_wrap} or
\code{facet_grid}. Default is \code{NULL}.}

\item{legend_ncol}{Number of columns in legend.}

\item{env}{environment for evaluating expressions.}
}
\description{
creates a histogram plot
}
\examples{
histogram_plot(airquality, "Wind", group = "Month")
histogram_plot(airquality, "Wind", "..density..", facet_x = "Month")
}
