% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contributions.R
\name{two_category_contribution}
\alias{two_category_contribution}
\title{Plot the contribution to a measure by combinations of two categories}
\usage{
two_category_contribution(
  data,
  category1,
  category2,
  measure,
  separate = FALSE
)
}
\arguments{
\item{data}{A data frame or tibble}

\item{category1, category2}{Unquoted names of category columns (can be factor, character or numeric)}

\item{measure}{Unquoted name of measure}

\item{separate}{Boolean to indicate whether the plots for different combinations should be in different facets}
}
\value{
A ggplot plot object
}
\description{
Plot the contribution to a measure by combinations of two categories
}
\examples{
two_category_contribution(ggplot2::diamonds, cut, clarity, price)
two_category_contribution(ggplot2::diamonds,  clarity, cut, price, separate = TRUE)
}
