% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seq.R
\name{plot_seq}
\alias{plot_seq}
\title{Plot of raw data over time}
\usage{
plot_seq(
  data = NULL,
  trial_number = NULL,
  AOIs = NULL,
  bg_image = NULL,
  res = c(0, 1920, 0, 1080),
  flip_y = FALSE,
  plot_header = FALSE,
  bin_time = NULL,
  bin_range = NULL
)
}
\arguments{
\item{data}{A dataframe with raw data. If multiple trials are used, then one trial is sampled at random.}

\item{trial_number}{can be used to select a particular trial within the data}

\item{AOIs}{A dataframe of areas of interest (AOIs), with one row per AOI (x, y, width_radius, height).}

\item{bg_image}{The filepath of an image to be added to the plot, for example to show a screenshot of the task.}

\item{res}{resolution of the display to be shown, as a vector (xmin, xmax, ymin, ymax)}

\item{flip_y}{reverse the y axis coordinates (useful if origin is top of the screen)}

\item{plot_header}{display the header title text which explains graphical features of the plot.}

\item{bin_time}{if wanting to split data into bins, the time (in ms) for each bin of data to be displayed}

\item{bin_range}{if wanting to split data into bins, the first and last bin to be display, e.g., c(1,5)}
}
\value{
a plot of the raw data representing changes over time
}
\description{
A tool for visualising the timecourse of raw data over a single trial. If data from multiple trials are present, then
a single trial will be sampled at random. Alternatively, the trial_number can be specified. Data can be plotted across the whole
trial, or can be split into bins to present distinct plots for each time window.
}
\examples{
data <- combine_eyes(HCL)

# plot the raw data
plot_seq(data = data[data$pNum == 118,])

# with AOIs
plot_seq(data = data[data$pNum == 118,], AOIs = HCL_AOIs)

# plot raw data with bins
plot_seq(data = data[data$pNum == 118,], bin_time = 500)

}
