% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoother.R
\name{smoother}
\alias{smoother}
\title{Smoothing of raw data}
\usage{
smoother(data, span = 0.1, plot = FALSE, participant_ID = "participant_ID")
}
\arguments{
\item{data}{A dataframe with raw data (time, x, y, trial) for one participant}

\item{span}{From stats::loess. The parameter alpha which controls the degree of smoothing.}

\item{plot}{whether to plot the raw and smoothed plot for inspection}

\item{participant_ID}{the variable that determines the participant identifier. If no column present, assumes a single participant}
}
\value{
a dataframe of the same shape as the input data
}
\description{
A wrapper for the stats::loess function, with default parameters suitable for smoothing raw eye data
}
\details{
It can take either single participant data or multiple participants where there is a variable for unique participant identification.
The function looks for an identifier named \code{participant_ID} by default and will treat this as multiple-participant data as default,
if not it is handled as single participant data, or the participant_ID needs to be specified
}
\examples{
data <- combine_eyes(HCL)

smoother(data, participant_ID = "pNum")

#with an inspection plot
smoother(data, span = .02, participant_ID = "pNum", plot = TRUE)

}
