% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_algorithms.R
\name{compare_algorithms}
\alias{compare_algorithms}
\title{A battery of metrics and plots to compare the two algorithms (dispersion and VTI)}
\usage{
compare_algorithms(
  data,
  plot_fixations = TRUE,
  print_summary = TRUE,
  sample_rate = NULL,
  threshold = 100,
  min_dur = 150,
  min_dur_sac = 20,
  disp_tol = 100,
  NA_tol = 0.25,
  run_interp = TRUE,
  smooth = FALSE
)
}
\arguments{
\item{data}{A dataframe with raw data (time, x, y, trial) for one participant}

\item{plot_fixations}{Whether to plot the detected fixations. default as TRUE}

\item{print_summary}{Whether to print the summary table. default as TRUE}

\item{sample_rate}{sample rate of the eye-tracker. If default of NULL, then it will be computed from the timestamp data and the number of samples. Supplied to the VTI algorithm}

\item{threshold}{velocity threshold (degrees of VA / sec) to be used for identifying saccades. Supplied to the VTI algorithm}

\item{min_dur}{Minimum duration (in milliseconds) of period over which fixations are assessed. Supplied to both algorithms.}

\item{min_dur_sac}{Minimum duration (in milliseconds) for saccades to be determined. Supplied to the VTI algorithm}

\item{disp_tol}{Maximum tolerance (in pixels) for the dispersion of values allowed over fixation period. Supplied to both algorithms}

\item{NA_tol}{the proportion of NAs tolerated within any window of samples that is evaluated as a fixation. Supplied to the dispersion algorithm}

\item{run_interp}{include a call to eyetools::interpolate on each trial. Supplied to the VTI algorithm}

\item{smooth}{include a call to eyetools::smoother on each trial. Supplied to the VTI algorithm}
}
\value{
a list of the fixation data, correlation output, and data used for plotting
}
\description{
A tool for comparing the two different algorithms present in this package. This function is useful for assessing the data as well as exploring which algorithm is likely to fit data more appropriately.
The raw data is run through both algorithms (using the same specified dispersion tolerances, etc.) before making comparisons of the underlying data. Can only be used for single participant data.
}
\examples{
\donttest{
data <- combine_eyes(HCL)
compare_algorithms(data[data$pNum == 118,])
}

}
