% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/permfnr.R
\name{permfnr}
\alias{permfnr}
\title{Confidence bands for the sample return time extremogram}
\usage{
permfnr(x, m, type, exttype, maxlag, uplevel = 1, lowlevel = 0, start = 1,
  alpha = 0.05)
}
\arguments{
\item{x}{Univariate time series (a vector).}

\item{m}{Number of permutations (an integer).}

\item{type}{Type of confidence bands. If type=1, it adds all permutations to the sample
extremogram plot. If type=2, it adds the \code{alpha}/2 and (1-\code{alpha})/2 empirical
confidence bands for each lag. If type=3, it calculates the lag 1 \code{alpha}/2 and
(1-\code{alpha})/2 empirical confidence bands lag and uses them for all of the lags.}

\item{exttype}{Extremogram type (see  \code{\link{extremogramr}}).}

\item{maxlag}{Number of lags to include in the extremogram (an integer).}

\item{uplevel}{Quantile of the time series to indicate a upper tail extreme event
(a number between 0 and 1, default is 1).}

\item{lowlevel}{Quantile of the time series to indicate a lower tail extreme event
(a number between 0 and 1, default is 0).}

\item{start}{The lag that the extremogram plots starts at (an integer not greater than \code{maxlag}, default is 1).}

\item{alpha}{Significance level for the confidence bands (a number between 0 and 1, default is 0.05).}
}
\description{
The function estimates empirical confidence bands for the sample returt time extremogram
             via a permutation procedure under the assumption that the data are independent.
}
\examples{
# generate a GARCH(1,1) process
omega    = 1
alpha    = 0.1
beta     = 0.6
n        = 1000
uplevel  = 0.95
lowlevel = 0.05
exttype  = 3
maxlag   = 70
type     = 3
m        = 10
df       = 3
G = extremogram:::garchsim(omega,alpha,beta,n,df)

extremogramr(G, type, maxlag, uplevel, lowlevel, 1, 1)
permfnr(G, m, type, exttype, maxlag, uplevel, lowlevel, 1, 0.05)
}
\references{
\enumerate{
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2012). Towards estimating extremal
            serial dependence via the bootstrapped extremogram. Journal of Econometrics,170(1),
            142-152.
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2011). Estimating extremal
            dependence in univariate and multivariate time series via the extremogram.arXiv
            preprint arXiv:1107.5592.}
}

