% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens.R
\name{sens_gamma_pois_zi}
\alias{sens_gamma_pois_zi}
\title{Adjust Zero-Inflated Gamma-Poisson Distribution Parameters for Sensitivity Analyses}
\usage{
sens_gamma_pois_zi(lambda, theta, prob, sd_mult = 2)
}
\arguments{
\item{lambda}{A non-negative numeric vector of means.}

\item{theta}{A non-negative numeric vector of the dispersion for the mixture
models (student, gamma-Poisson and beta-binomial).}

\item{prob}{A numeric vector of values between 0 and 1 of the probability of
success.}

\item{sd_mult}{A non-negative multiplier on the standard deviation of the
distribution.}
}
\value{
A named list of the adjusted distribution's parameters.
}
\description{
Expands (\code{sd_mult > 1}) or reduces (\code{sd_mult < 1}) the standard deviation
of the Zero-Inflated Gamma-Poisson distribution.
}
\examples{
sens_gamma_pois_zi(10, 0.1, 0.3, 2)
}
\seealso{
Other sens_dist: 
\code{\link{sens_beta}()},
\code{\link{sens_exp}()},
\code{\link{sens_gamma}()},
\code{\link{sens_gamma_pois}()},
\code{\link{sens_lnorm}()},
\code{\link{sens_neg_binom}()},
\code{\link{sens_norm}()},
\code{\link{sens_pois}()},
\code{\link{sens_skewnorm}()},
\code{\link{sens_student}()}
}
\concept{sens_dist}
