% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens.R
\name{sens_beta}
\alias{sens_beta}
\title{Adjust Beta Distribution Parameters for Sensitivity Analyses}
\usage{
sens_beta(alpha, beta, sd_mult = 2)
}
\arguments{
\item{alpha}{The first shape parameter of the Beta distribution.}

\item{beta}{The second shape parameter of the Beta distribution.}

\item{sd_mult}{A non-negative multiplier on the standard deviation of the
distribution.}
}
\value{
A named list of the adjusted distribution's parameters.
}
\description{
Expands (\code{sd_mult > 1}) or reduces (\code{sd_mult < 1}) the standard deviation
of the Beta distribution. The Beta distribution has a maximum variance of
\verb{mean(x) * (1 - mean(x)}, where \code{mean(x) = alpha / (alpha + beta)}. If the
inputs produce a desired variance that is greater than the maximum possible
variance, or provides alpha and/or beta parameters that are \verb{< 1} and thus
push more probability weight towards extreme probability values, this
function returns \code{alpha = 1} and \code{beta = 1} (the uniform distribution).
}
\examples{
sens_beta(10, 10, 2)
sens_beta(10, 10, 0.8)
}
\seealso{
Other sens_dist: 
\code{\link{sens_exp}()},
\code{\link{sens_gamma}()},
\code{\link{sens_gamma_pois}()},
\code{\link{sens_gamma_pois_zi}()},
\code{\link{sens_lnorm}()},
\code{\link{sens_neg_binom}()},
\code{\link{sens_norm}()},
\code{\link{sens_pois}()},
\code{\link{sens_skewnorm}()},
\code{\link{sens_student}()}
}
\concept{sens_dist}
