% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse-gamma-distribution.R
\name{InvGamma}
\alias{InvGamma}
\alias{dinvgamma}
\alias{pinvgamma}
\alias{qinvgamma}
\alias{rinvgamma}
\title{Inverse-gamma distribution}
\usage{
dinvgamma(x, alpha, beta = 1, log = FALSE)

pinvgamma(q, alpha, beta = 1, lower.tail = TRUE, log.p = FALSE)

qinvgamma(p, alpha, beta = 1, lower.tail = TRUE, log.p = FALSE)

rinvgamma(n, alpha, beta = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha, beta}{positive valued shape and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function and random generation
for the inverse-gamma distribution.
}
\details{
Probability mass function
\deqn{
f(x) = \frac{x^{-\alpha-1} \exp(-\frac{1}{\beta x})}{\Gamma(\alpha) \beta^\alpha}
}{
f(x) = (x^(-\alpha-1) * exp(-1/(\beta*x))) / (\Gamma(\alpha)*\beta^\alpha)
}

Cumulative distribution function
\deqn{
F(x) = \frac{\gamma(\alpha, \frac{1}{\beta x})}{\Gamma(\alpha)}
}{
F(x) = \gamma(\alpha, 1/(\beta*x)) / \Gamma(\alpha)
}
}
\examples{

x <- rinvgamma(1e5, 20, 3)
xx <- seq(0, 1, by = 0.001)
hist(x, 100, freq = FALSE)
lines(xx, dinvgamma(xx, 20, 3), col = "red")
hist(pinvgamma(x, 20, 3))
plot(ecdf(x))
lines(xx, pinvgamma(xx, 20, 3), col = "red", lwd = 2) 

}
\references{
Witkovsky, V. (2001). Computing the distribution of a linear
combination of inverted gamma variables. Kybernetika 37(1), 79-90.

Leemis, L.M. and McQueston, L.T. (2008). Univariate Distribution
Relationships. American Statistician 62(1): 45-53.
}
\seealso{
\code{\link[stats]{GammaDist}}
}
\keyword{distribution}
