% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birnbaum-saunders-distribution.R
\name{BirnbaumSaunders}
\alias{BirnbaumSaunders}
\alias{dfatigue}
\alias{pfatigue}
\alias{qfatigue}
\alias{rfatigue}
\title{Birnbaum-Saunders (fatigue life) distribution}
\usage{
dfatigue(x, alpha, beta = 1, mu = 0, log = FALSE)

pfatigue(q, alpha, beta = 1, mu = 0, lower.tail = TRUE, log.p = FALSE)

qfatigue(p, alpha, beta = 1, mu = 0, lower.tail = TRUE, log.p = FALSE)

rfatigue(n, alpha, beta = 1, mu = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha, beta, mu}{shape, scale and location parameters.
Scale and shape must be positive.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Birnbaum-Saunders (fatigue life) distribution.
}
\details{
Probability density function
\deqn{
f(x) = \left (\frac{\sqrt{\frac{x-\mu} {\beta}} + \sqrt{\frac{\beta} 
{x-\mu}}} {2\alpha (x-\mu)} \right) 
\phi \left( \frac{1}{\alpha}\left( \sqrt{\frac{x-\mu}{\beta}} -
\sqrt{\frac{\beta}{x-\mu}} \right) \right)
}{
f(x) = ((sqrt((x-\mu)/\beta) + sqrt(\beta/(x-\mu)))/(2*\alpha*(x-\mu))) *
\phi((sqrt((x-\mu)/\beta) - sqrt(\beta/(x-\mu)))/\alpha)
}

Cumulative distribution function
\deqn{
F(x) = \Phi \left(\frac{1}{\alpha}\left( \sqrt{\frac{x-\mu}{\beta}} -
\sqrt{\frac{\beta}{x-\mu}} \right) \right)
}{
F(x) = \Phi(((sqrt((x-\mu)/\beta) - sqrt(\beta/(x-\mu)))/\alpha)
}

Quantile function
\deqn{
F^{-1}(p) = \left[\frac{\alpha}{2} \Phi^{-1}(p) +
\sqrt{\left(\frac{\alpha}{2} \Phi^{-1}(p)\right)^{2} + 1}\right]^{2} \beta + \mu
}{
F^-1(p) = (\alpha/2 * \Phi^-1(p) +
sqrt((\alpha/2 * \Phi^-1(p))^2 + 1)^2 * \beta + \mu
}
}
\examples{

x <- rfatigue(1e5, .5, 2, 5)
xx <- seq(0, 1000, by = 0.1)
hist(x, 100, freq = FALSE)
lines(xx, dfatigue(xx, .5, 2, 5), col = "red")
hist(pfatigue(x, .5, 2, 5))
plot(ecdf(x))
lines(xx, pfatigue(xx, .5, 2, 5), col = "red", lwd = 2)

}
\references{
Birnbaum, Z. W. and Saunders, S. C. (1969).
A new family of life distributions.
Journal of Applied Probability, 6(2), 637-652.

Desmond, A. (1985) Stochastic models of failure in random environments.
Canadian Journal of Statistics, 13, 171-183.

Vilca-Labra, F., and Leiva-Sanchez, V. (2006).
A new fatigue life model based on the family of skew-elliptical distributions.
Communications in Statistics-Theory and Methods, 35(2), 229-244.

Leiva, V., Sanhueza, A., Sen, P. K., and Paula, G. A. (2008).
Random number generators for the generalized Birnbaum-Saunders distribution.
Journal of Statistical Computation and Simulation, 78(11), 1105-1118.
}
\keyword{distribution}
