% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrset.R
\name{mrset}
\alias{mrset}
\alias{mdset}
\title{Create multiple response set/multiple dichotomy set from variables}
\usage{
mrset(..., label = NULL)

mdset(..., label = NULL)
}
\arguments{
\item{...}{variables}

\item{label}{character optional label for multiple response set}
}
\value{
data.frame of class \code{category}/\code{dichotomy}
}
\description{
These functions are intended for usage with tables - \link{tables},
\link{cro}, \link{cro_fun}. Result of \code{mrset} is considered as 
muliple-response set with category encoding and result of \code{mdset} is 
considered as multiple response set with dichotomy (dummy) encoding e. g. 
with 0 or 1 in the each column. Each column in the \code{dichotomy} is 
indicator of absense or presense of particular feature. Both functions don't 
convert its arguments to anything - it is supposed that arguments already 
have appropriate encoding. For conversation see \link{as.dichotomy} or 
\link{as.category}.
}
\examples{

data(product_test)
a1 = calculate(product_test, mrset(a1_1 \%to\% a1_6))

}
\seealso{
\link{as.dichotomy}, \link{as.category}
}
