% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum.R
\name{sum_row}
\alias{sum_row}
\alias{sum_col}
\alias{mean_row}
\alias{mean_col}
\alias{sd_row}
\alias{sd_col}
\alias{median_row}
\alias{median_col}
\alias{max_row}
\alias{max_col}
\alias{min_row}
\alias{min_col}
\alias{apply_row}
\alias{apply_col}
\alias{any_in_row}
\alias{any_in_col}
\alias{all_in_row}
\alias{all_in_col}
\title{Compute sum/mean/sd/median/max/min/custom function on rows/columns}
\usage{
sum_row(..., na.rm = TRUE)

sum_col(..., na.rm = TRUE)

mean_row(..., na.rm = TRUE)

mean_col(..., na.rm = TRUE)

sd_row(..., na.rm = TRUE)

sd_col(..., na.rm = TRUE)

median_row(..., na.rm = TRUE)

median_col(..., na.rm = TRUE)

max_row(..., na.rm = TRUE)

max_col(..., na.rm = TRUE)

min_row(..., na.rm = TRUE)

min_col(..., na.rm = TRUE)

apply_row(fun, ...)

apply_col(fun, ...)

any_in_row(..., na.rm = TRUE)

any_in_col(..., na.rm = TRUE)

all_in_row(..., na.rm = TRUE)

all_in_col(..., na.rm = TRUE)
}
\arguments{
\item{...}{data. Vectors, matrixes, data.frames, list. Shorter arguments
will be recycled.}

\item{na.rm}{logical. Contrary to the base 'sum' it is TRUE by default. Should missing values (including NaN)
be removed?}

\item{fun}{custom function that will be applied to \dots}
}
\value{
All functions except \code{apply_*} return numeric vector of length 
  equals the number of argument columns/rows. Value of \code{apply_*} depends
  on supplied \code{fun} function.
}
\description{
These functions are intended for usage inside \link[maditr]{let}, and
\link[maditr]{let_if}. sum/mean/sd/median/max/min by default omits NA. \code{any_in_*}
checks existence of any TRUE in each row/column. It is equivalent of
\link[base]{any} applied to each row/column. \code{all_in_*} is equivalent of
\link[base]{all} applied to each row/column.
}
\examples{
iris = iris \%>\% 
    let( 
        new_median = median_row(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width),
        new_mean = mean_row(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
    )
  
dfs = data.frame(
    test = 1:5,
    aa = rep(10, 5),
    b_ = rep(20, 5),
    b_1 = rep(11, 5),
    b_2 = rep(12, 5),
    b_4 = rep(14, 5),
    b_5 = rep(15, 5) 
)

# calculate sum of b* variables
dfs \%>\% 
    let( 
        b_total = sum_row(b_, b_1 \%to\% b_5)
    ) \%>\% 
    print()

# conditional modification
dfs \%>\% 
    let_if(test \%in\% 2:4, 
        b_total = sum_row(b_, b_1 \%to\% b_5)
    ) \%>\% 
    print()


}
\seealso{
\link{\%to\%}, \link{count_if},
  \link{sum_if}, \link{mean_if}, \link{median_if}, \link{sd_if},
  \link{min_if}, \link{max_if}
}
