% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph2office.R
\name{graph2office}
\alias{graph2office}
\alias{graph2doc}
\alias{graph2ppt}
\title{Save currently active R graph to Microsoft Office / LibreOffice format}
\usage{
graph2office(
  x = NULL,
  file = "Rplot",
  fun = NULL,
  type = c("PPT", "DOC"),
  append = FALSE,
  aspectr = NULL,
  width = NULL,
  height = NULL,
  scaling = 100,
  paper = "auto",
  orient = ifelse(type[1] == "PPT", "landscape", "auto"),
  margins = c(top = 0.5, right = 0.5, bottom = 0.5, left = 0.5),
  center = TRUE,
  offx = 1,
  offy = 1,
  upscale = FALSE,
  vector.graphic = TRUE,
  ...
)

graph2ppt(...)

graph2doc(...)
}
\arguments{
\item{x}{given \code{ggplot2} plot or \code{lattice} plot object to export; if
set to \code{NULL} the currently active R graph will be exported; not
supported for base R plots.}

\item{file}{name of output file. Any extension is ignored and added
according to the requested output type.}

\item{fun}{plot passed on as a function used to create it; useful especially
for base R plots.}

\item{type}{desired output type - \code{DOC} for Word document, \code{PPT} for Powerpoint.}

\item{append}{logical value - if \code{TRUE} and \code{type=PPT} it will append the graph
to the given file, where file can also be a given corporate template. If
\code{append=FALSE} any existing file will be overwritten. Currently ignored in
Word export.}

\item{aspectr}{desired width to height aspect ratio. If set to \code{NULL}, the
aspect ratio of the active graphics device is used.}

\item{width}{desired width in inches; can be combined with a desired
aspect ratio aspectr.}

\item{height}{desired height in inches; can be combined with a desired
aspect ratio aspectr.}

\item{scaling}{scale width & height by a certain percentage.}

\item{paper}{desired paper size to use - "A5" to "A1" for Powerpoint export,
or "A5" to "A3" for Word output; default "auto" automatically selects the
paper size that fits your graph. Graphs that are too large to fit on a given
paper size are scaled down.}

\item{orient}{desired paper orientation - "auto", "portrait" or "landscape";
default to "auto" for Word output and to "landscape" for Powerpoint.}

\item{margins}{vector with the desired margins that should be left blank in}

\item{center}{logical specifying whether or not to center the graph
in the exported Powerpoint.}

\item{offx}{if center is set to \code{FALSE}, the desired x offset at which to
place one's graph in Powerpoint output.}

\item{offy}{if center is set to \code{FALSE}, the desired y offset at which to
place one's graph in Powerpoint output.}

\item{upscale}{logical specifying whether or not to upscale one's graph to
make it page-filling (excluding the margins). Note that scaling may result
in a different look of one's graph relative to how it looks on the screen
due to the change in size.}

\item{vector.graphic}{logical specifying whether or not to output in
vectorized format. This avoids pixelated images in the document. Note that 
for PowerPoint, the image can be edited after first ungrouping the plot 
elements. If set to \code{FALSE}, the plot is rasterized to \code{PNG} bitmap
format at a resolution of 300 dpi.}

\item{\dots}{any other options are passed on to \code{rvg}'s 
\code{\link[rvg]{dml_pptx}} function if \code{type == "DOC"} or to 
\code{devEMF}'s \code{\link{emf}} function if \code{type == "PPT"} (only 
when \code{vector.graphics == TRUE}).}
}
\value{
No return value
}
\description{
Save the currently active R graph or a graph passed as an object or function 
to Microsoft Office / LibreOffice format with sensible defaults
}
\section{Functions}{
\itemize{
\item \code{graph2ppt()}: Save currently active R graph to a Microsoft Office PowerPoint/LibreOffice Impress presentation

\item \code{graph2doc()}: Save currently active R graph to a Microsoft Office Word/LibreOffice Writer document

}}
\examples{
# Create a file name
filen <- tempfile(pattern = "ggplot") # or 
# filen <- paste("YOUR_DIR/ggplot")

# Generate graphical output
library(ggplot2)
library(datasets)
x=qplot(Sepal.Length, Petal.Length, data = iris, 
        color = Species, size = Petal.Width, alpha = I(0.7))
plot.fun = function(){
  print(qplot(Sepal.Length, Petal.Length, data = iris, 
              color = Species, size = Petal.Width, alpha = I(0.7)))
}

# There are 3 ways to use graph2office():
### 1. Pass the plot as an object
graph2ppt(x=x, file=filen) 
graph2doc(x=x, file=filen, aspectr=0.5) 
### 2. Get the plot from current screen device
if (interactive()) { 
  x
  graph2ppt(file=filen, width=9, aspectr=2, append = TRUE)
  graph2doc(file=filen, aspectr=1.7, append =TRUE) 
  # Note this requires a graphical device
}
### 3. Pass the plot as a function
if (interactive()) { 
  graph2ppt(fun=plot.fun, file=filen, aspectr=0.5, append = TRUE)
  graph2doc(fun=plot.fun, file=filen, aspectr=0.5, append = TRUE)
  # Note this requires a graphical device
} 

### Formatting options:
# Disable vectorized image export (export as a bitmap)
graph2ppt(x=x, file=filen, vector.graphic=FALSE, width=9, 
          aspectr=sqrt(2), append = TRUE) 
# Fill the slide with graph
graph2ppt(x=x, file=filen, margins=0, upscale=TRUE, append=TRUE) 
# etc...
}
\seealso{
\code{\link{graph2vector}}, \code{\link{graph2svg}}, \code{\link{graph2pdf}}, \code{\link{graph2eps}},
\code{\link{graph2bitmap}}, \code{\link{graph2png}}, \code{\link{graph2tif}}, \code{\link{graph2jpg}}
}
\author{
Tom Wenseleers, Christophe Vanderaa
}
