% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{set_limits}
\alias{set_limits}
\title{Adjustment of limits}
\usage{
set_limits(
  rl,
  rl_sf,
  sl,
  sl_sf,
  sf_option = "loose",
  xform = c("no", "no"),
  shift = c(0, 0),
  ivl_side = "lower"
)
}
\arguments{
\item{sl}{A numeric value or a numeric vector of length \code{2} specifying
the specification limit or limits. If a vector is provided it must be of
the form \code{c(lower limit, upper limit)}.}

\item{sl_sf}{A positive integer or a vector of positive integers specifying
the number of \dQuote{significant figures} (sf) of \code{sl}. It must have
the same length as \code{sl}.}

\item{sf_option}{A character string specifying if the limits (\code{rl}
or \code{sl}) should be regarded as \dQuote{tight} or \dQuote{loose}, i.e.
either \code{"tight"} or \code{"loose"}, respectively. The option
\code{"tight"} means that the limits are rounded to the specified number
of significant figures specified by the parameters \code{rl_sf} and
\code{sl_sf}. In case of the option \code{"loose"} the limits are rounded
to the specified number of significant figures (\eqn{n}), followed by the
subtraction of \eqn{1} from the \eqn{n^{th}} digit and addition of
\eqn{5} to the \eqn{(n + 1)^{th}} digit if \code{ivl_side} is
\code{"lower"}, or followed by the addition of \eqn{4} to the
\eqn{(n + 1)^{th}} digit if \code{ivl_side} is \code{"upper"}.}

\item{xform}{A vector of two character strings specifying the transformation
of the response and the time variable. The default is \dQuote{no}
transformation, i.e. \code{c("no", "no")}, where the first element
specifies the transformation of the \eqn{x} variable and the second
element the transformation of the \eqn{y} variable. Valid alternatives
for \eqn{x} and/or \eqn{y} variable transformation are \code{"log"}
(natural logarithm), \code{"sqrt"} (square root) and \code{"sq"} (square).}

\item{shift}{A vector of two values which will be added to the variables
\eqn{x} and/or \eqn{y} before they are transformed as specified by the
\code{xform} parameter, where the first element will be added to the
\eqn{x} variable and the second element to the \eqn{y} variable. The
purpose is to prevent an undefined state which could arise when variables
with values of \eqn{\leq 0} are log or square root transformed. The
default is \code{c(0, 0)}.}

\item{ivl_side}{A character string specifying if the \dQuote{upper} or the
\dQuote{lower} limit is the relevant limit, i.e. either \code{"upper"} or
\code{"lower"}, respectively. The default is \code{"lower"}.}
}
\value{
A list with the following elements is returned:
\item{sf.option}{A character string specifying the option concerning the
  significant figures.}
\item{xform}{A vector of two character strings specifying the transformation
  of the response and the time variable.}
\item{shift}{A vector of two values to be added to the values of the
  transformed \eqn{x} and/or \eqn{y} variables (specified via the
  \code{xform} parameter).}
\item{rl.orig}{An optional element containing a numeric value or a numeric
  vector specifying the release limit(s) on the original scale.}
\item{rl.sf}{An optional element containing a numeric value or a numeric
  vector specifying the significant figures of the release limit(s).}
\item{rl}{An optional element containing a numeric value or a numeric vector
  of the adjusted (as specified by the \code{sf.option} parameter) release
  limit(s).}
\item{rl.trfmd}{An optional element containing a numeric value or a numeric
  vector of the adjusted and transformed, if applicable (as specified by the
  the \code{sf.option} parameter and the second element of the \code{xform}
  parameter, respectively), release limit(s), otherwise the same as
  \code{rl}.}
\item{sl.orig}{A numeric value or a numeric vector of length \code{2}
  specifying the specification limit(s) on the original scale.}
\item{sl.sf}{A numeric value or a numeric vector of length \code{2}
  specifying the significant figures of the specification limit(s).}
\item{sl}{A numeric value or a numeric vector of length \code{2} of the
  adjusted (as specified by the \code{sf.option} parameter) specification
  limit(s).}
\item{sl.trfmd}{A numeric value or a numeric vector of length \code{2} of
  the adjusted and transformed, if applicable (as specified by the the
  \code{sf.option} parameter and the second element of the \code{xform}
  parameter, respectively) specification limit(s), otherwise the same as
  \code{sl}.}
}
\description{
The function \code{set_limits()} adjusts the limits according to the number
of relevant decimal places and according to the transformation requirement.
}
\details{
The function \code{set_limits()} adjusts the limits according to
\code{rl_sf} and \code{sl_sf} and, if necessary, transforms the limits
(\code{rl} and \code{sl}) as specified by the parameters \code{xform} and
\code{shift}.
}
\keyword{internal}
