% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expirest_wisle.R
\name{plot_expirest_wisle}
\alias{plot_expirest_wisle}
\title{Illustrating the what-if (approach for) shelf life estimate (wisle)}
\usage{
plot_expirest_wisle(
  model,
  rl_index = 1,
  show_grouping = "yes",
  response_vbl_unit = NULL,
  y_range,
  x_range = NULL,
  scenario = "standard",
  plot_option = "full",
  ci_app = "line"
)
}
\arguments{
\item{model}{An \sQuote{\code{expirest_wisle}} object, i.e. a list returned
by the \code{\link{expirest_wisle}()} function.}

\item{rl_index}{A positive integer specifying which of the release limit
values that have been handed over to \code{\link{expirest_wisle}()} should
be displayed. The default value is \code{1}.}

\item{show_grouping}{A character string specifying if the grouping of the
data should be taken into account (\dQuote{yes}) or not (\dQuote{no}),
i.e. if the results of the most appropriate model should be shown or
the results from the marginal analysis ignoring the grouping (being
equivalent with the \emph{common intercept / common slope case}). The
default is \code{"yes"}.}

\item{response_vbl_unit}{A character string specifying the unit associated
with the response variable. The default is \code{NULL}.}

\item{y_range}{A numeric vector of the form \code{c(min, max)} specifying
the range of the response variable to be plotted.}

\item{x_range}{A numeric vector of the form \code{c(min, max)} specifying
the range of the time  variable to be plotted. The default is \code{NULL}
and the \eqn{x} range is calculated automatically on the basis of the
estimated shelf life.}

\item{scenario}{A character string specifying if the plot should be extended
(with respect to the \eqn{x} axis) up to the \dQuote{standard scenario}
(\code{"standard"}) or up to the \dQuote{worst case scenario}
(\code{"worst"}). The default is \code{"standard"}.}

\item{plot_option}{A character string of either \code{"full"},
\code{"lean1"}, \code{"lean2"}, \code{"basic1"} and \code{"basic2"},
specifying if all the information should be shown in the plot (option
\code{"full"}) or only basic information (options \code{"lean"} and
\code{"basic"}). Full means the data points, the fitted regression line
with the confidence or prediction interval, the specification limit(s)
and the estimated shelf life. The default is \code{"full"}.}

\item{ci_app}{A character string of either \code{"line"} or \code{"ribbon"},
specifying the appearance of the confidence interval, i.e. if the limits
should be plotted as lines (option \code{"line"}) or as a shaded ribbon
(option \code{"ribbon"}). The default is \code{"line"}.}
}
\value{
An object of class \sQuote{\code{plot_expirest_wisle}} is returned
invisibly consisting of the following elements:
\item{Model}{The \sQuote{\code{expirest_wisle}} object that was passed via
  the \code{model} argument.}
\item{Expiery}{A data frame of type \code{expiry}.}
\item{Graph}{A \sQuote{\code{ggplot2}} object for the graphical display.}
\item{Prediction}{A data frame of the predicted values.}
\item{text}{A data frame of the text elements on the plot.}
\item{hlines}{A data frame of the horizontal line elements on the plot.}
\item{vlines}{A data frame of the vertical line elements on the plot.}
\item{segments}{A data frame of segment line elements on the plot.}
\item{arrow}{A data frame of arrow elements on the plot.}
}
\description{
The function \code{plot_expirest_wisle()} makes a graphical display of the
shelf life estimate done by the \code{\link{expirest_wisle}()} function.
}
\details{
The function \code{plot_expirest_wisle()} uses the data and the
information about the linear model that was used for the estimation of
the shelf life by aid of the \code{\link{expirest_wisle}()} function. It
plots a graph of the time course of a parameter, a linear regression line
fitted to the data and the associated confidence or prediction interval.
In addition, it shows features of the worst case scenario shelf life
estimation.

For plotting, the \code{\link[ggplot2]{ggplot}()} function from the
\sQuote{\code{ggplot2}} package is used. The various arguments can be
used to control the appearance of the plot. The \sQuote{\code{ggplot2}}
object of the generated plot is contained in the \code{Graph} element of
the list that is returned by \code{\link{plot_expirest_wisle}()} and can be
used to modify the appearance of the graph.
}
\examples{
# Potency stability data (in \% of label claim (LC)) of five batches of a drug
# product obtained over a 24 months period:
str(exp1)

# 'data.frame':	53 obs. of  3 variables:
# $ Batch  : Factor w/ 6 levels "b2","b3","b4",..: 1 1 1 1 1 1 1 1 1 1 ...
# $ Month  : num  0 1 3 3 6 6 12 12 24 24 ...
# $ Potency: num  101 101.3 99.8 99.2 99.5 ...

# Start by making a "what-if (approach for) shelf life estimation" (wisle)
res1 <-
  expirest_wisle(data = exp1[exp1$Batch \%in\% c("b2", "b5", "b7"), ],
                 response_vbl = "Potency", time_vbl = "Month",
                 batch_vbl = "Batch", rl = 98, rl_sf = 3, sl = 95,
                 sl_sf = 3, srch_range = c(0, 500))

# Pass the 'expirest_wisle' object on to the plot_expirest_wisle() function.
# This function does not produce any output. It returns a 'plot_expirest_wisle'
# object that is essentially an 'expirest_wisle' object augmented by a 'ggplot'
# object.
gg1 <- plot_expirest_wisle(
  model = res1, rl_index = 1, show_grouping = "no",
  response_vbl_unit = "\%", y_range = c(93, 107), x_range = NULL,
  scenario = "standard", plot_option = "full", ci_app = "line")
gg1

# Since the element gg1$Graph is a 'ggplot' object it can be used for further
# manipulation by aid of 'ggplot2' functions.
if (requireNamespace("ggplot2")) {
  library(ggplot2)

  gg1$Graph + labs(title = "What-if Shelf Life Estimation (WISLE)",
                   x = "Time [months]", y = "Potency [\% LC]") +
    scale_x_continuous(limits = c(-5, 31), breaks = seq(0, 30, 6))
}

# Illustration of the grouping
gg2 <- plot_expirest_wisle(
  model = res1, rl_index = 1, show_grouping = "yes",
  response_vbl_unit = "\%", y_range = c(93, 107), x_range = NULL,
  scenario = "standard", plot_option = "full", ci_app = "line")
gg2

# Repeat this for a different intercept / different slope (dids) model.
res2 <-
  expirest_wisle(data = exp1[exp1$Batch \%in\% c("b4", "b5", "b8"), ],
                 response_vbl = "Potency", time_vbl = "Month",
                 batch_vbl = "Batch", rl = 98, rl_sf = 3, sl = 95,
                 sl_sf = 3, srch_range = c(0, 500))

gg3 <- plot_expirest_wisle(
  model = res2, rl_index = 1, show_grouping = "yes",
  response_vbl_unit = "\%", y_range = c(89, 107), x_range = c(0, 26),
  scenario = "standard", plot_option = "full", ci_app = "ribbon")
gg3
}
\seealso{
\code{\link{expirest_wisle}}, \code{\link{expirest_osle}}.
}
