% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluxDifferences.R
\name{fluxDifferences}
\alias{fluxDifferences}
\title{Report the fold change of fluxes between two models}
\usage{
fluxDifferences(model1, model2, foldReport = 2)
}
\arguments{
\item{model1}{A valid model for the \code{'sybil'} package.}

\item{model2}{A valid model for the \code{'sybil'} package. Must have the same reactions (reaction number and reaction identifiers) as \code{"model1"} with different restrictions.}

\item{foldReport}{A threshold value to be reported. All reactions with a greater or equal fold change than the given threshold are reported.}
}
\description{
This functions calculates the fold change \code{"(fluxModel2/fluxModel1)-1"} for the fluxes of two given metabolic models.
}
\examples{
\dontrun{
# Loading a model
library("sybil")
library("Biobase")
data("Ec_core")

# Generating expressionSets
expressionData <- matrix(data = runif(3*length(Ec_core@allGenes),min = 1,max = 100),
                         nrow = length(Ec_core@allGenes),
                         dimnames = list(c(Ec_core@allGenes),c()))
expressionData <- ExpressionSet(assayData = expressionData)

# Applying exp2flux
Ec_coreGE <- exp2flux(model = Ec_core,
                      expression = expressionData,
                      missing = "mean")

# Evaluating Differences
fluxDifferences(model1 = Ec_core, 
                model2 = Ec_coreGE, 
                foldReport = 0.5)
                }
}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}
\keyword{between}
\keyword{differences}
\keyword{flux}
\keyword{identify}
\keyword{model}
\keyword{scenarios}
\keyword{two}

