% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp2flux.R
\name{exp2flux}
\alias{exp2flux}
\title{Convert gene expression data to FBA fluxes}
\usage{
exp2flux(model, expression, organism = NULL, typeID = NULL,
  missing = "mean", scale = FALSE)
}
\arguments{
\item{model}{A valid model for the \code{'sybil'} package.}

\item{expression}{A valid ExpressionSet object (one by treatment).}

\item{organism}{A valid organism identifier for the KEGG database. List of valid organism identifiers are available in: http://rest.kegg.jp/list/organism.}

\item{typeID}{A string to define the type of ID used in GPR's. One of \code{"entrez"} or \code{"kegg"} must be given.}

\item{missing}{A character string specifying the value to be used in missing cases; must be one of \code{'min'}, \code{'1q'}, \code{'mean'}, \code{'median'}, \code{'3q'}, or \code{'max'}}

\item{scale}{A boolean value to specify if data must be scaled to assign a value of 1000 as max.}
}
\description{
This function calculates the flux boundaries for each reaction based in their associated GPR. 
The value es obtained as follows: When two genes are associated by an \code{AND} operation according to the GPR rule, a \code{min} function is applied to their associated expression values. 
In the \code{AND} case, downregulated genes alter the reaction acting as enzyme formation limitant due two are required to complex formation. 
In turn, when the genes are associated by an \code{OR} rule, each one of then can code an entire enzyme to act as reaction catalyst. 
In this case, a \code{sum} function is applied for their associated expression values.To missing gene expression values, the function assigns one of: \code{'min'}, \code{'1q'}, \code{'mean'}, \code{'median'}, \code{'3q'}, or \code{'max'} expression value calculated from the genes associated to the same metabolic pathway.
In case of not possible pathway assignment to a gene, the value is calculated from all gene expression values. 
The fluxes boundaries of exchange reactions are not modified.
}
\examples{
\dontrun{
# Loading a model
library("sybil")
library("Biobase")

# Original model:
data("Ec_core")

# Original model evaluation:
optimizeProb(Ec_core)

# Generating simulated expressionSets
expressionData <- matrix(data = runif(3*length(Ec_core@allGenes),min = 1,max = 100),
                         nrow = length(Ec_core@allGenes),
                         dimnames = list(c(Ec_core@allGenes),c()))
expressionData <- ExpressionSet(assayData = expressionData)

# Applying exp2flux
Ec_coreGE <- exp2flux(model = Ec_core,
                      expression = expressionData,
                      missing = "mean")
# Evaluating exp2flux model
optimizeProb(Ec_coreGE)
                }
}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co> and Kelly Botero <kjboteroo@unal.edu.co>
}
\keyword{data}
\keyword{expression}
\keyword{genome}
\keyword{integrate}
\keyword{metabolic}
\keyword{network}
\keyword{reconstruction}
\keyword{scale}
\keyword{tissue-specific}

