
#' Read EXIF data
#'
#' This function has been deprecated, use \link{read_exif} instead.
#'
#' @param filename A vector of filenames (like that generated by
#'   \code{list.files(..., full.names=TRUE)})
#' @param recursive If directory is specified by \code{filename}, process files recursively.
#' @param quiet \code{FALSE} if status updates are desired, \code{TRUE}
#'   otherwise.
#' @param exiftoolargs a list of args to be passed to ExifTool (e.g. \code{c("-filename", "-imagesize")})
#'
#' @export
#'
exifr <- function(filename, recursive=FALSE, quiet=TRUE, exiftoolargs=NULL) {
  message("exifr() is deprecated, and has been replaced by read_exif()")
  read_exif(path = filename, recursive = recursive, args = exiftoolargs, quiet = quiet)
}

#' Call exiftool from R
#'
#' This function has been deprecated. Use \link{exiftool_call} instead.
#'
#' @param args a list of non-shell quoted arguments (e.g. \code{-n -csv})
#' @param fnames a list of filenames (\code{shQuote()} will be applied to this vector)
#' @param intern \code{TRUE} if output should be returned as a character vector.
#' @param ... additional arguments to be passed to \code{system()}
#'
#' @export
#'
exiftool.call <- function(args=c("--help"), fnames=NULL, intern=FALSE, ...) {
  message("exiftool.call has been deprecated and has been replaced by exiftool_call()")
  exiftool_call(args = args, fnames = fnames, intern = intern, ...)
}


# private helper command
exiftool.command <- function(args, fnames) {
  exiftoolpath <- options("exifr.exiftoolcommand")$exifr.exiftoolcommand
  if(is.null(exiftoolpath)) stop("ExifTool not properly installed")
  if(length(fnames) > 0) {
    paste(exiftoolpath, paste(args, collapse=" "), paste(shQuote(fnames), collapse=" "))
  } else {
    paste(exiftoolpath, paste(args, collapse=" "))
  }
}
