% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{check_location}
\alias{check_location}
\title{Check for locations outside of the US}
\usage{
check_location(
  x,
  id_col = "ResponseId",
  location_col = c("LocationLatitude", "LocationLongitude"),
  include_na = FALSE,
  keep = FALSE,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{location_col}{Two element vector specifying columns for latitude
and longitude (in that order).}

\item{include_na}{Logical indicating whether to include rows with NA in
latitude and longitude columns in the output list of potentially excluded
data.}

\item{keep}{Logical indicating whether to keep or remove exclusion column.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
The output is a data frame of the rows that are located outside of
the US and (if \code{include_na == FALSE}) rows with no location information.
For a function that marks these rows, use \code{\link[=mark_location]{mark_location()}}.
For a function that excludes these rows, use \code{\link[=exclude_location]{exclude_location()}}.
}
\description{
The \code{check_location()} function subsets rows of data, retaining rows
that have locations outside of the US.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The function only works for the United States.
It uses the #' \code{\link[maps:map.where]{maps::map.where()}} to determine if latitude and longitude
are inside the US.

The function outputs to console a message about the number of rows
with locations outside of the US.
}
\examples{
# Check for locations outside of the US
data(qualtrics_text)
check_location(qualtrics_text)

# Remove preview data first
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_location()

# Do not print rows to console
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_location(print = FALSE)

# Do not print message to console
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_location(quiet = TRUE)
}
\seealso{
Other location functions: 
\code{\link{exclude_location}()},
\code{\link{mark_location}()}

Other check functions: 
\code{\link{check_duplicates}()},
\code{\link{check_duration}()},
\code{\link{check_ip}()},
\code{\link{check_preview}()},
\code{\link{check_progress}()},
\code{\link{check_resolution}()}
}
\concept{check functions}
\concept{location functions}
