% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_label_rows.R
\name{remove_label_rows}
\alias{remove_label_rows}
\title{Remove two initial rows created in Qualtrics data}
\usage{
remove_label_rows(x, convert = TRUE, rename = FALSE)
}
\arguments{
\item{x}{Data frame (downloaded from Qualtrics).}

\item{convert}{Logical indicating whether to convert/coerce date, logical and
numeric columns from the metadata.}

\item{rename}{Logical indicating whether to rename columns based on first row
of data.}
}
\value{
An object of the same type as \code{x} that excludes Qualtrics label rows and
with date, logical, and numeric metadata columns converted to the correct
data class.
}
\description{
The \code{remove_label_rows()} function filters out the initial label rows from
datasets downloaded from \href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
The function (1) checks if the data set uses Qualtrics column names,
(2) checks if label rows are already used as column names,
(3) removes label rows if present, and (4) converts date, logical, and
numeric metadata columns to proper data type. Datasets imported using
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{qualtRics::fetch_survey()}
should not need this function.

The \code{convert} argument only converts the \emph{StartDate}, \emph{EndDate},
\emph{RecordedDate}, \emph{Progress}, \emph{Finished}, \emph{Duration (in seconds)},
\emph{LocationLatitude}, and \emph{LocationLongitude} columns. To convert other data
columns, see \code{\link[dplyr:mutate]{dplyr::mutate()}}.
}
\examples{
# Remove label rows
data(qualtrics_raw)
df <- remove_label_rows(qualtrics_raw)
}
\concept{helper}
