% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch02TestItemAnalysis.R
\name{ItemStatistics}
\alias{ItemStatistics}
\title{Simple Item Statistics}
\usage{
ItemStatistics(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}
}
\value{
\describe{
\item{NR}{Number of Respondents}
\item{CRR}{Correct Response Rate denoted as $p_j$.}
\item{ODDs}{Item Odds is the ratio of the correct response rate to the incorrect response rate.
Defined as \eqn{o_j = \frac{p_j}{1-p_j}}}
\item{Threshold}{Item Threshold is a measure of difficulty based on a standard normal distribution.}
\item{Entropy}{Item Entropy is an indicator of the variability or randomness of the responses.
Defined as \eqn{e_j=-p_j \log_2 p_j - (1-p_j)\log_2(1-p_j)}}
\item{ITCrr}{Item-total Correlation is a Pearson's correlation fo an item with the number of Number-Right score.}
}
}
\description{
This function calculates statistics for each item.
}
\examples{
# using sample dataset
ItemStatistics(J15S500)
}
