% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact_extract.R
\name{exact_extract}
\alias{exact_extract}
\alias{exact_extract,Raster,sf-method}
\alias{exact_extract,Raster,sfc_MULTIPOLYGON-method}
\alias{exact_extract,Raster,sfc_POLYGON-method}
\alias{exact_extract,Raster,sfc_GEOMETRY-method}
\title{Extract or summarize values from Raster* objects}
\usage{
\S4method{exact_extract}{Raster,sf}(
  x,
  y,
  fun = NULL,
  ...,
  include_xy = FALSE,
  progress = TRUE,
  max_cells_in_memory = 3e+07,
  include_cell = FALSE,
  force_df = FALSE,
  full_colnames = FALSE,
  stack_apply = FALSE,
  append_cols = NULL,
  include_cols = NULL,
  quantiles = NULL
)

\S4method{exact_extract}{Raster,sfc_MULTIPOLYGON}(
  x,
  y,
  fun = NULL,
  ...,
  weights = NULL,
  include_xy = FALSE,
  progress = TRUE,
  max_cells_in_memory = 3e+07,
  include_cell = FALSE,
  force_df = FALSE,
  full_colnames = FALSE,
  stack_apply = FALSE,
  append_cols = NULL,
  include_cols = NULL,
  quantiles = NULL
)

\S4method{exact_extract}{Raster,sfc_POLYGON}(
  x,
  y,
  fun = NULL,
  ...,
  weights = NULL,
  include_xy = FALSE,
  progress = TRUE,
  max_cells_in_memory = 3e+07,
  include_cell = FALSE,
  force_df = FALSE,
  full_colnames = FALSE,
  stack_apply = FALSE,
  append_cols = NULL,
  include_cols = NULL,
  quantiles = NULL
)

\S4method{exact_extract}{Raster,sfc_GEOMETRY}(
  x,
  y,
  fun = NULL,
  ...,
  weights = NULL,
  include_xy = FALSE,
  progress = TRUE,
  max_cells_in_memory = 3e+07,
  include_cell = FALSE,
  force_df = FALSE,
  full_colnames = FALSE,
  stack_apply = FALSE,
  append_cols = NULL,
  include_cols = NULL,
  quantiles = NULL
)
}
\arguments{
\item{x}{a \code{RasterLayer}, \code{RasterStack}, or \code{RasterBrick}}

\item{y}{a sf object with polygonal geometries}

\item{fun}{an optional function or character vector, as described below}

\item{...}{additional arguments to pass to \code{fun}}

\item{include_xy}{if \code{TRUE}, and \code{fun} is \code{NULL}, augment
the returned data frame for each feature with columns
for cell center coordinates (\code{x} and \code{y}). If
\code{TRUE} and \code{fun} is not \code{NULL}, add
\code{x} and {y} to the data frame passed to \code{fun}
for each feature.}

\item{progress}{if \code{TRUE}, display a progress bar during processing}

\item{max_cells_in_memory}{the maximum number of raster cells to load at
a given time when using a named summary operation
for \code{fun} (as opposed to a function defined using
R code). If a polygon covers more than \code{max_cells_in_memory}
raster cells, it will be processed in multiple chunks.}

\item{include_cell}{if \code{TRUE}, and \code{fun} is \code{NULL}, augment
the returned data frame for each feature with a column
for the cell index (\code{cell}). If \code{TRUE} and
\code{fun} is not \code{NULL}, add \code{cell} to the
data frame passed to \code{fun} for each feature.}

\item{force_df}{always return a data frame instead of a vector, even if
\code{x} has only one layer and \code{fun} has length 1}

\item{full_colnames}{include the names of \code{x} in the names of the
returned data frame, even if \code{x} has only one
layer. This is useful when the results of multiple
calls to \code{exact_extract} are combined with
\code{cbind}.}

\item{stack_apply}{if \code{TRUE}, apply \code{fun} to each layer of
\code{x} independently. If \code{FALSE}, apply \code{fun}
to all layers of \code{x} simultaneously.}

\item{append_cols}{when \code{fun} is not \code{NULL}, an optional
character vector of columns from \code{y} to be
included in returned data frame.}

\item{include_cols}{an optional character vector of column names in
\code{y} to be added to the data frame for each
feature that is either returned (when \code{fun} is
\code{NULL}) or passed to \code{fun}.}

\item{quantiles}{quantiles to be computed when \code{fun == 'quantile'}}

\item{weights}{a weighting raster to be used with the \code{weighted_mean}
and \code{weighted_sum} summary operations.}
}
\value{
a vector or list of data frames, depending on the type of \code{x} and the
        value of \code{fun} (see Details)
}
\description{
Extracts the values of cells in a Raster* that are covered by a
simple feature collection containing polygonal geometries, as well as the
fraction of each cell that is covered by the polygon. Returns either
the result of a summary operation or function applied to the values
and coverage fractions (if \code{fun} is specified), or a data frame
containing the values and coverage fractions themselves (if \code{fun}
is \code{NULL}.)
}
\details{
The value of \code{fun} may be set to a string (or vector of strings)
representing summary operations supported by the exactextract library.
If the input raster has a single layer and a single summary operation
is specified, \code{exact_extract} will return a vector with the result
of the summary operation for each feature in the input. If the input
raster has multiple layers, or if multiple summary operations are specified,
\code{exact_extract} will return a data frame with a row for each feature
and a column for each summary operation / layer combination. (The
\code{force_df} can be used to always return a data frame instead of a vector.)
In all of the summary operations, \code{NA} values in the raster are ignored
(i.e., \code{na.rm = TRUE}.)

The following summary operations are supported:

\itemize{
 \item{\code{min} - the minimum defined value in any raster cell wholly or
                    partially covered by the polygon}
 \item{\code{max} - the maximum defined value in any raster cell wholly or
                    partially covered by the polygon}
 \item{\code{count} - the sum of fractions of raster cells with defined values
                      covered by the polygon}
 \item{\code{sum}   - the sum of defined raster cell values, multiplied by
                      the fraction of the cell that is covered by the polygon}
 \item{\code{mean} - the mean cell value, weighted by the fraction of each cell
                     that is covered by the polygon}
 \item{\code{median} - the median cell value, weighted by the fraction of each
                       cell that is covered by the polygon}
 \item{\code{quantile} - arbitrary quantile(s) of cell values, specified in
                         \code{quantiles}, weighted by the fraction of each
                         cell that is covered by the polygon}
 \item{\code{mode} - the most common cell value, weighted by the fraction of
                     each cell that is covered by the polygon. Where multiple
                     values occupy the same maximum number of weighted cells,
                     the largest value will be returned.}
 \item{\code{majority} - synonym for \code{mode}}
 \item{\code{minority} - the least common cell value, weighted by the fraction
                         of each cell that is covered by the polygon. Where
                         multiple values occupy the same minimum number of
                         weighted cells, the smallest value will be returned.}
 \item{\code{variety} - the number of distinct values in cells that are wholly
                        or partially covered by the polygon.}
 \item{\code{variance} - the population variance of cell values, weighted by the
                         fraction of each cell that is covered by the polygon.}
 \item{\code{stdev} - the population standard deviation of cell values, weighted
                      by the fraction of each cell that is covered by the polygon.}
 \item{\code{coefficient_of_variation} - the population coefficient of variation of
                      cell values, weighted by the fraction of each cell that is
                      covered by the polygon.}
 \item{\code{weighted_mean} - the mean cell value, weighted by the product of
                              the fraction of each cell covered by the polygon
                              and the value of a second weighting raster provided
                              as \code{weights}}
 \item{\code{weighted_sum} - the sum of defined raster cell values, multiplied by
                             the fraction of each cell that is covered by the polygon
                              and the value of a second weighting raster provided
                              as \code{weights}}
}

Alternatively, an R function may be provided as \code{fun}. The function will be
called for each feature with with vectors of cell values and weights as arguments.
\code{exact_extract} will then return a vector of the return values of \code{fun}.

If \code{fun} is not specified, \code{exact_extract} will return a list with
one data frame for each feature in the input feature collection. The data
frame will contain a column with values from each layer in the input `Raster*`,
and a final column indicating the fraction of the cell that is covered by the
polygon.
}
\examples{
rast <- raster::raster(matrix(1:100, ncol=10), xmn=0, ymn=0, xmx=10, ymx=10)
poly <- sf::st_as_sfc('POLYGON ((2 2, 7 6, 4 9, 2 2))')

# named summary operation on RasterLayer, returns vector
exact_extract(rast, poly, 'mean')

# two named summary operations on RasterLayer, returns data frame
exact_extract(rast, poly, c('min', 'max'))

# named summary operation on RasterStack, returns data frame
stk <- raster::stack(list(a=rast, b=sqrt(rast)))
exact_extract(stk, poly, 'mean')

# named weighted summary operation, returns vector
weights <- raster::raster(matrix(runif(100), ncol=10), xmn=0, ymn=0, xmx=10, ymx=10)
exact_extract(rast, poly, 'weighted_mean', weights=weights)

# custom summary function, returns vector
exact_extract(rast, poly, function(value, cov_frac) length(value[cov_frac > 0.9]))

}
