% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{POWER}
\alias{POWER}
\title{Exact Power of Test for Selected Sample Sizes.}
\usage{
POWER(
  n0,
  n1,
  alpha = 0.05,
  delta = 0,
  psi = 0,
  type = "lr",
  p0 = NULL,
  obj = NULL
)
}
\arguments{
\item{n0}{control sample size}

\item{n1}{treatment sample size}

\item{alpha}{value of nominal size of test}

\item{delta}{value of clinically relevant difference}

\item{psi}{null value of risk difference p1-p0}

\item{type}{either "lr" for approximate or "elr" for quasi-exact test}

\item{p0}{baseline probability. If missing, a grid of values is created for
plotting. A scalar value can also be supplied.}

\item{obj}{Optional object with all possible p-values. Must be a list with
elements y0, y1, P (typically output of lr.rd or ESTEP.rd). If not supplied
then object is generated from n0, n1 and psi.}
}
\value{
list with element x (containing values of baseline probability)
and element y (containing corresponding exact powers)
}
\description{
For known values of the sizes n0, this function computes the
exact probability of rejecting the null as a function of baseline
probability.
}
\details{
p0 values must be between max(0,-delta) and min(1,1-delta)
}
\examples{
oldpar <- graphics::par()
# Typical usage
#       POWER(n0=65,n1=82,psi=0,type="lr") # Exact size of approximate lr test
#       POWER(n0=65,n1=82,psi=0,type="elr",delta=.2) # Exact power of quasi exact test
# To make examples run faster, the package includes objects that contain
# all possible values of various tests when n0=65, n1=82.
load(system.file('files', "lr.stats.Rdata", package = 'exact.n'))
# All possible values of LR statistic p-values for testing p1-p0>0
load(system.file('files', "elr.stats.Rdata", package = 'exact.n'))
# All possible values of ELR statistic p-values for testing p1-p0>0
load(system.file('files', "elr10.stats.Rdata", package = 'exact.n'))
# Object contains all exact p-values for testing if p1-p0>0.1
# All possible values of ELR statistic p-values for testing p1-p0>0.1
#
graphics::par(mfrow=c(1,2))
# When delta=0 this gives type 1 error. The first plot is for the approximate
# lr based p-value, the second is for the quasi-exact e-p-value (alpha=0.05)
plot(POWER(n0=65,n1=82,alpha=0.05,psi=0,delta=0),type="l",
     xlab=expression("p"[0]),ylab="exact size")
abline(h=.05,lty=2)
plot(POWER(obj=elr.stats,alpha=0.05,delta=0),type="l",
     xlab=expression("p"[0]),ylab="exact size")
abline(h=.05,lty=2)
#
# For these sample sizes, power curve is calculated below for
# values of delta=0.1, 0.12, 0.14, 0.16, 0.18, 0.20. Power
# is poor for detecting a difference of 0.1 (see red).
plot(POWER(obj=lr.stats,alpha=0.05,delta=0.1),type="l",
     xlab=expression("p"[0]),ylab="exact power")
TITLE=expression('Exact power of LR test of p'[1]*'-p'[0]*'>0.')
title(main=TITLE,cex.main=0.8)
lines(POWER(obj=lr.stats,alpha=0.05,delta=0.12))
lines(POWER(obj=lr.stats,alpha=0.05,delta=0.14))
lines(POWER(obj=lr.stats,alpha=0.05,delta=0.16))
lines(POWER(obj=lr.stats,alpha=0.05,delta=0.18))
lines(POWER(obj=lr.stats,alpha=0.05,delta=0.20))
lines(POWER(obj=lr.stats,alpha=0.05,delta=0.10),col="red")
#
# The results below are for testing p1-p0>0.1.
plot(c(0,.9),c(0,1),type="n",
     xlab=expression("p"[0]),ylab="Pr(reject null)")
lines(POWER(obj=elr10.stats,alpha=0.05,psi=0.1,delta=0.1)) # Note delta=psi
abline(h=0.05,lty=2)
lines(POWER(obj=elr10.stats,alpha=0.05,delta=0.25),col="blue")
TITLE=expression('Exact size and power of test of p'[1]*'-p'[0]*'>0.1.')
title(main=TITLE,cex.main=0.8)
legend(.4,.4,lty=c(1,1),col=c("black","blue"),box.col="white",
    legend=c("size: p1-p0=0.1","power: p1-p0=0.25"),cex=.7)
# When using the package the above plots would be generated by
# lines(POWER(n0=65,n1=82,alpha=0.05,psi=0.1,delta=0.10,type="elr"))
# lines(POWER(n0=65,n1=82,alpha=0.05,psi=0.1,delta=0.25,type="elr"))
suppressWarnings(graphics::par(oldpar))

}
\references{
C.J. Lloyd & R. Ripamonti (2021) A comprehensive open-source
library for exact required sample size in binary clinical trials.
Contemporary Clinical Trials 107. \doi{10.1016/j.cct.2021.106491}
}
\author{
Chris J. Lloyd
}
