% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ENNreg.R
\name{predict.ENNreg}
\alias{predict.ENNreg}
\title{Prediction method for the ENNreg model}
\usage{
\method{predict}{ENNreg}(object, newdata, yt = NULL, ...)
}
\arguments{
\item{object}{An object of type "ENNreg"}

\item{newdata}{Input matrix of attributes for test data}

\item{yt}{Optional test response vector}

\item{...}{Further arguments passed to or from other methods}
}
\value{
Predictions for the new data, coded as a list with the following components:
\describe{
\item{mux}{Predicted means}
\item{sigx}{Predicted standard deviations.}
\item{hx}{Prediction precisions.}
\item{Einf}{Lower expectation.}
\item{Esup}{Upper expectations}
\item{NLL}{Negative log likelihood (computed only if yt is provided).}
\item{RMS}{Root mean squared error (computed only if yt is provided).}
}
}
\description{
Predicted values based on a trained ENNreg model (object of class "ENNreg").
}
\examples{
# Boston dataset
\donttest{
library(MASS)
X<-as.matrix(scale(Boston[,1:13]))
y<-Boston[,14]
set.seed(220322)
n<-nrow(Boston)
ntrain<-round(0.7*n)
train <-sample(n,ntrain)
fit <- ENNreg(X[train,],y[train],K=30)
pred<-predict(fit,newdata=X[-train,],yt=y[-train])
plot(y[-train],pred$mux,xlab="observed response",ylab="predicted response")
}

}
\seealso{
\code{\link{ENNreg}}, \code{\link{ENNreg_init}}
}
