% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abm-tabu.R
\name{abm.tabu}
\alias{abm.tabu}
\title{Tabu Search metaheuristic}
\usage{
abm.tabu(objective, options = NULL)
}
\arguments{
\item{objective}{An instance of ObjectiveFunction (or subclass) class \link{ObjectiveFunction}}

\item{options}{An apropiate instance from a sublclass of \link{Options} class}
}
\description{
An implementation of Tabu Search algorithm for parameter estimation
}
\examples{
\dontrun{
 f<- PlainFunction$new(f0.rosenbrock2)

 f$Parameter(name="x1",min=-100,max=100)
 f$Parameter(name="x2",min=-100,max=100)

 or

 f$Parameter0(name="x1",levels=c(0:4))
 f$Parameter0(name="x2",levels=c(-2,-1,0,1,2))

 extremize("tabu", f)
}

}
\references{
[1] Fred Glover (1989). "Tabu Search - Part 1". ORSA Journal on Computing,
190-206. doi:10.1287/ijoc.1.3.190.
[2] Fred Glover (1990). "Tabu Search - Part 2". ORSA Journal on Computing,
4-32. doi:10.1287/ijoc.2.1.4.
}
