% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{PlymouthOzoneMaxima}
\alias{PlymouthOzoneMaxima}
\title{Annual maxima ozone levels at Plymouth, UK}
\format{
\code{PlymouthOzoneMaxima} is a data frame with 27 rows (years 1998 to
2024) and the 4 variables:
\itemize{
\item \code{maxima}: annual maximum ozone level in \eqn{\mu}g/m\eqn{^3}.
\item \code{notNA} : the number of days of the year for which raw data were available.
\item \code{n} : the number of days in the year (365 or 366).
\item \code{block} : a block number of 1 for year 1998 through to 27 for year 2024.
}

The row names of \code{PlymouthOzoneMaxima} are the years \code{1998:2024}.
The raw data are missing for approximately \eqn{10\%} of the days.
}
\source{
The Department for Environment Food and Rural Affair (DEFRA).
The Plymouth Centre monitoring site at
the \href{https://uk-air.defra.gov.uk/}{UK-AIR} database
\href{https://uk-air.defra.gov.uk/data/data_selector}{Data Selector}.
}
\usage{
PlymouthOzoneMaxima
}
\description{
Annual maxima of daily maximum ozone levels at Plymouth in Devon (UK)
for the years 1998-2024 inclusive.
}
\examples{
head(PlymouthOzoneMaxima)

# Time series plot of annual maxima ozone levels
plot(rownames(PlymouthOzoneMaxima), PlymouthOzoneMaxima$maxima,
     ylab = "ozone (micrograms / metre cubed)", xlab = "year", pch = 16)

# Time series plot of proportion of non-missing days
plot(rownames(PlymouthOzoneMaxima),
     PlymouthOzoneMaxima$notNA / PlymouthOzoneMaxima$n,
     ylab = "proportion of non-missing days", xlab = "year", pch = 16)

# Plot ozone levels against the proportion of non-missing days
plot(PlymouthOzoneMaxima$notNA / PlymouthOzoneMaxima$n,
     PlymouthOzoneMaxima$maxima,
     ylab = "ozone (micrograms / metre cubed)",
     xlab = "proportion of non-missing days", pch = 16)
}
\seealso{
\code{\link{PlymouthOzone}} for the raw time series.
}
\keyword{datasets}
