% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evinb.R
\name{evinb}
\alias{evinb}
\title{Running an extreme value inflated negative binomial model with bootstrapping}
\usage{
evinb(
  formula_nb,
  formula_evi = NULL,
  formula_pareto = NULL,
  data,
  bootstrap = TRUE,
  n_bootstraps = 100,
  multicore = FALSE,
  ncores = NULL,
  block = NULL,
  boot_seed = NULL,
  max.diff.par = 0.01,
  max.no.em.steps = 500,
  max.no.em.steps.warmup = 5,
  c.lim = c(50, 1000),
  max.upd.par.pl.multinomial = 0.5,
  max.upd.par.nb = 0.5,
  max.upd.par.pl = 0.5,
  no.m.bfgs.steps.multinomial = 3,
  no.m.bfgs.steps.nb = 3,
  no.m.bfgs.steps.pl = 3,
  pdf.pl.type = "approx",
  eta.int = c(-1, 1),
  init.Beta.multinom.PL = NULL,
  init.Beta.NB = NULL,
  init.Beta.PL = NULL,
  init.Alpha.NB = 0.01,
  init.C = 200,
  verbose = FALSE
)
}
\arguments{
\item{formula_nb}{Formula for the negative binomial (count) component of the model}

\item{formula_evi}{Formula for the extreme-value inflation component of the model. If NULL taken as the same formula as nb}

\item{formula_pareto}{Formula for the pareto (extreme value) component of the model. If NULL taken as the same formula as nb}

\item{data}{Data to run the model on}

\item{bootstrap}{Should bootstrapping be performed. Needed to obtain standard errors and p-values}

\item{n_bootstraps}{Number of bootstraps to run. For use of bootstrapped p-values, at least 1,000 bootstraps are recommended. For approximate p-values, a lower number can be sufficient}

\item{multicore}{Should multiple cores be used?}

\item{ncores}{Number of cores if multicore is used. Default (NULL) is one less than the available number of cores}

\item{block}{Optional string indicating a case-identifier variable when using block bootstrapping}

\item{boot_seed}{Optional bootstrap seed to ensure reproducible results.}

\item{max.diff.par}{Tolerance for EM algorithm. Will be considered to have converged if the maximum absolute difference in the parameter estimates are lower than this value}

\item{max.no.em.steps}{Maximum number of EM steps to run. Will be considered to not have converged if this number is reached and convergence is not reached}

\item{max.no.em.steps.warmup}{Number of EM steps in the warmup rounds}

\item{c.lim}{Integer range defining the possible values of C}

\item{max.upd.par.pl.multinomial}{Maximum parameter change step size in the extreme value inflation component}

\item{max.upd.par.nb}{Maximum parameter change step size in the count component}

\item{max.upd.par.pl}{Maximum parameter change step size in the pareto component}

\item{no.m.bfgs.steps.multinomial}{Number of BFGS steps for the multinomial model}

\item{no.m.bfgs.steps.nb}{Number of BFGS steps for the negative binomial model}

\item{no.m.bfgs.steps.pl}{Number of BFGS steps for the pareto model}

\item{pdf.pl.type}{Probability density function type for the pareto component. Either 'approx' or 'exact'. 'approx' is adviced in most cases}

\item{eta.int}{Initial values for eta}

\item{init.Beta.multinom.PL}{Initial values for beta parameters in the extreme value inflation component. Vector of same length as number of parameters in the extreme value inflation component or NULL (which gives starting values of 0)}

\item{init.Beta.NB}{Initial values for beta parameters in the count component. Vector of same length as number of parameters in the count component or NULL (which gives starting values of 0)}

\item{init.Beta.PL}{Initial values for beta parameters in the pareto component. Vector of same length as number of parameters in the pareto component or NULL (which gives starting values of 0)}

\item{init.Alpha.NB}{Initial value of Alpha NB, integer or NULL (giving a starting value of 0)}

\item{init.C}{Initial value of C. Integer which should be within the C_lim range.}

\item{verbose}{Should progress be printed for the first run of evinb}
}
\value{
An object of class 'evinb'
}
\description{
Running an extreme value inflated negative binomial model with bootstrapping
}
\examples{
data(genevzinb2)
model <- evinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10)

}
