\name{marma}
\alias{marma}
\alias{mar}
\alias{mma}
\title{Simulate MARMA(p,q) Processes}
\description{
  Simulation of MARMA(p,q) processes. 
}
\usage{
marma(n, p = 0, q = 0, psi, theta, init = rep(0, p), n.start = p,
    rand.gen = rfrechet, \dots)
mar(n, p = 1, psi, init = rep(0, p), n.start = p, rand.gen =
    rfrechet, \dots)
mma(n, q = 1, theta, rand.gen = rfrechet, \dots)
}
\arguments{
  \item{n}{The number of observations.}
  \item{p}{The AR order of the MARMA process.}
  \item{q}{The MA order of the MARMA process.}
  \item{psi}{A vector of non-negative parameters, of length
    \code{p}. Can be omitted if \code{p} is zero.}
  \item{theta}{A vector of non-negative parameters, of length
    \code{q}. Can be omitted if \code{q} is zero.}
  \item{init}{A vector of non-negative starting values, of
    length \code{p}.}
  \item{n.start}{A non-negative value denoting the length of the
    burn-in period. If \code{n.start} is less than \code{p}, then
    \code{p} minus \code{n.start} starting values will be included
    in the output series.}
  \item{rand.gen}{A simulation function to generate the
    innovations.}
  \item{\dots}{Additional arguments for \code{rand.gen}.  Most
    usefully, the scale and shape parameters of the innovations
    generated by \code{rfrechet} can be specified by \code{scale}
    and \code{shape} respectively.}
}
\details{
  A max autoregressive moving average process \eqn{\{X_k\}}{{X_k}},
  denoted by MARMA(p,q), satisfies
  \deqn{X_k = \max\{\phi_1 X_{k-1}, \ldots, \phi_p X_{k-p}, \epsilon_k,
    \theta_1 \epsilon_{k-1}, \ldots, \theta_q \epsilon_{k-q}\}}{
    X_k = max[phi_1 X_{k-1}, \ldots, phi_p X_{k-p}, epsilon_k,
    theta_1 epsilon_{k-1}, \ldots, theta_q epsilon_{k-q}]}
  where \eqn{\code{phi} = (\phi_1, \ldots, \phi_p)}{
    \code{phi} = (phi_1, \ldots, phi_p)}
  and \eqn{\code{theta} = (\theta_1, \ldots, \theta_q)}{
    \code{theta} = (theta_1, \ldots, theta_q)}
  are non-negative vectors of parameters, and where
  \eqn{\{\epsilon_k\}}{{epsilon_k}} is a series of \emph{iid}
  random variables with a common distribution defined by
  \code{rand.gen}.

  The functions \code{mar} and \code{mma} generate MAR(p) and
  MMA(q) processes respectively.
  A MAR(p) process \eqn{\{X_k\}}{{X_k}} is equivalent to a
  MARMA(p, 0) process, so that
  \deqn{X_k = \max\{\phi_1 X_{k-1}, \ldots, \phi_p X_{k-p},
    \epsilon_k\}.}{X_k = max[phi_1 X_{k-1}, \ldots, phi_p X_{k-p},
    epsilon_k].}
  A MMA(q) process \eqn{\{X_k\}}{{X_k}} is equivalent to a
  MARMA(0, q) process, so that
  \deqn{X_k = \max\{\epsilon_k, \theta_1 \epsilon_{k-1}, \ldots,
    \theta_q \epsilon_{k-q}\}.}{X_k = max[epsilon_k, theta_1
    epsilon_{k-1}, \ldots, theta_q epsilon_{k-q}].}
}
\value{
  A numeric vector of length \code{n}.
}

\seealso{\code{\link{evmc}}}

\examples{
marma(100, p = 1, q = 1, psi = 0.75, theta = 0.65)
mar(100, psi = 0.85, n.start = 20)
mma(100, q = 2, theta = c(0.75, 0.8))
}
\keyword{distribution}

