% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_graphs.R
\name{theme_evaluator}
\alias{theme_evaluator}
\title{Default ggplot theme used by all Evaluator-supplied graphics}
\usage{
theme_evaluator(base_family = "BentonSansRE")
}
\arguments{
\item{base_family}{Font family.}
}
\value{
A ggplot theme object.
}
\description{
Returns a standardized ggplot theme used by all built-in Evaluator plots.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars) + geom_point(aes(wt, mpg, color = factor(gear))) + facet_wrap(~am)
font_family <- get_base_fontfamily()
p + theme_evaluator(font_family)
}
