% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_eurostat2.R
\name{tidy_eurostat2}
\alias{tidy_eurostat2}
\title{Transform Data from the New Dissemination API into Row-Column-Value Format}
\usage{
tidy_eurostat2(
  dat,
  time_format = "date",
  select_time = NULL,
  stringsAsFactors = FALSE,
  keepFlags = FALSE
)
}
\arguments{
\item{dat}{a data_frame from \code{\link[=get_eurostat_raw]{get_eurostat_raw()}}.}

\item{time_format}{a string giving a type of the conversion of the time column from the
eurostat format. A "date" (default) converts to a \code{\link[=Date]{Date()}}
with a first date of the period. A "date_last" converts to a \code{\link[=Date]{Date()}} with
a last date of the period. A "num" converts to a numeric and "raw"
does not do conversion. See \code{\link[=eurotime2date]{eurotime2date()}} and \code{\link[=eurotime2num]{eurotime2num()}}.}

\item{select_time}{a single character symbol for a time frequency, a vector
containing multiple time frequencies, or \code{NULL} (default).
Available options are "A" (annual), "Q" (quarterly), "S"
(semester, 1st or 2nd half of the year), "M" (monthly) and "D" (daily).
When downloading data from the New Dissemination API, it is now possible
to select multiple time frequencies and return them in the same data.frame
object.}

\item{stringsAsFactors}{if \code{TRUE} (the default) variables are
converted to factors in original Eurostat order. If \code{FALSE}
they are returned as strings.}

\item{keepFlags}{a logical whether the flags (e.g. "confidential",
"provisional") should be kept in a separate column or if they
can be removed. Default is \code{FALSE}}
}
\value{
tibble in the molten format with the last column 'values'.
}
\description{
Transform raw Eurostat data table downloaded from the new
dissemination API into the row-column-value format (RCV).
}
\examples{
\dontrun{
# Example of a dataset with multiple time series
get_eurostat("AVIA_GOR_ME", time_format = "date_last", cache = F, bulk_new_style = TRUE)
}

}
\references{
See citation("eurostat").
}
\seealso{
\code{\link[=get_eurostat]{get_eurostat()}}, \code{\link[=convert_time_col2]{convert_time_col2()}}, \code{\link[=eurotime2date2]{eurotime2date2()}}
}
\author{
Przemyslaw Biecek, Leo Lahti, Janne Huovari and Pyry Kantanen
}
\keyword{database}
\keyword{internal}
\keyword{utilities}
