% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eurotime2num.R
\name{eurotime2num}
\alias{eurotime2num}
\title{Conversion of Eurostat Time Format to Numeric}
\usage{
eurotime2num(x)
}
\arguments{
\item{x}{a charter string with time information in Eurostat time format.}
}
\value{
see \code{\link{as.numeric}}.
}
\description{
A conversion of a Eurostat time format to numeric.
}
\details{
Bi-annual, quarterly and monthly data is presented as fraction of 
         the year in beginning of the period. Conversion of daily data is not 
         supported.
}
\examples{
\dontrun{
   lp <- get_eurostat("namq_aux_lp", time_format = "raw")
   lp$time <- eurotime2num(x = lp$time)
   
   un <- get_eurostat("une_rt_m", time_format = "raw")
   un$time <- eurotime2num(x = un$time)
   
   lpa <- get_eurostat("nama_aux_lp", time_format = "raw")
   lpa$time <- eurotime2num(x = lpa$time)
   }
}
\author{
Janne Huovari \email{janne.huovari@ptt.fi}
}
