% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_eurostat.R
\name{search_eurostat}
\alias{grepEurostatTOC}
\alias{search_eurostat}
\title{Grep datasets titles from eurostat}
\usage{
search_eurostat(pattern, type = "dataset")

grepEurostatTOC(pattern, type = "dataset")
}
\arguments{
\item{pattern}{Character, datasets, folder or tables with this pattern in 
the description will be returned (depending on the 'type' argument)}

\item{type}{Grep the Eurostat table of contents either for 
'dataset' (default), 'folder', 'table' or "all" (for all types) .}
}
\value{
A data.frame with eight columns
   \itemize{
 	\item{title}{The name of dataset of theme}
\item{code}{The codename of dataset of theme, will be used by the get_eurostat and get_eurostat_raw functions.}
\item{type}{Is it a dataset, folder or table.}
\item{last.update.of.data, last.table.structure.change, data.start, data.end}{Dates.}
   }
}
\description{
Lists names of dataset from eurostat with the particular
pattern in the description. Downloads list of all datasets available on
eurostat and return list of names of datasets that contains particular 
pattern in the dataset description. E.g. all datasets related to
education of teaching.
}
\section{Functions}{
\itemize{
\item \code{grepEurostatTOC}: Old deprecated version
}}
\examples{
\dontrun{tmp <- search_eurostat("education"); head(tmp)}
}
\author{
Przemyslaw Biecek and Leo Lahti \email{ropengov-forum@googlegroups.com}
}
\references{
See citation("eurostat")
}
\seealso{
\code{\link{get_eurostat}}, \code{\link{get_eurostat_toc}}
}
\keyword{database}
\keyword{utilities}

