% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elx_run_query.R
\name{elx_run_query}
\alias{elx_run_query}
\title{Execute SPARQL queries}
\usage{
elx_run_query(
  query = "",
  endpoint = "http://publications.europa.eu/webapi/rdf/sparql"
)
}
\arguments{
\item{query}{A valid SPARQL query specified by `elx_make_query()` or manually}

\item{endpoint}{SPARQL endpoint}
}
\value{
A data frame containing the results of the SPARQL query.
Column `work` contains the Cellar URI of the resource.
}
\description{
Executes cURL request to a pre-defined endpoint of the EU Publications Office.
Relies on elx_make_query to generate valid SPARQL queries.
Results are capped at 1 million rows.
}
\examples{
\donttest{
elx_run_query(elx_make_query("directive", include_force = TRUE, limit = 10))
}
}
