% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.euler.R
\name{panel.euler}
\alias{panel.euler}
\title{Panel Function for Euler Diagrams}
\usage{
panel.euler(x, y, ra, rb, phi, subscripts, fill = superpose.polygon$col,
  lty = superpose.polygon$lty, lwd = superpose.polygon$lwd,
  border = superpose.polygon$border, alpha = superpose.polygon$alpha,
  fontface = "bold", quantities = FALSE, labels = NULL, original.values,
  fitted.values, ...)
}
\arguments{
\item{x}{X coordinates for the centers.}

\item{y}{Y coordinates for the centers.}

\item{ra}{Semi-major axes.}

\item{rb}{Semi-minor axes.}

\item{phi}{Rotation of the ellipse (as the counter-clockwise angle from
the positive x-axis to the semi-major axis).}

\item{subscripts}{A vector of subscripts (See \code{\link[lattice:xyplot]{lattice::xyplot()}}).}

\item{fill}{Fill color. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{lty}{Line type. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{lwd}{Line weight. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{border}{Border color.}

\item{alpha}{Alpha (opacity) for the fill. Note that \code{\link[=plot.euler]{plot.euler()}} by
default modifies the alpha of \code{col} to avoid affecting the alpha of
the borders. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{fontface}{Fontface for the labels. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{quantities}{Plots the original values for the disjoint set combinations
(\code{original.values}). Can also be a list, in which the contents of the list
will be passed on to \code{\link[lattice:panel.text]{lattice::panel.text()}} to modify the appearance of
the quantity labels.}

\item{labels}{Labels.}

\item{original.values}{Original values for the disjoint set combinations.}

\item{fitted.values}{Fitted values for the disjoint set combinations.}

\item{...}{Passed down to \code{\link[=panel.euler.circles]{panel.euler.circles()}} or
\code{\link[=panel.euler.ellipses]{panel.euler.ellipses()}} and \code{\link[=panel.euler.labels]{panel.euler.labels()}}.}
}
\value{
Plots euler diagrams inside a trellis panel.
}
\description{
Plots circular euler diagrams if \code{ra == rb} and elliptical such otherwise.
}
\seealso{
\code{\link[grid:gpar]{grid::gpar()}}.
}
