% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizVsLTime.R
\name{VizVsLTime}
\alias{VizVsLTime}
\title{Plot a score along the forecast time with its confidence interval}
\usage{
VizVsLTime(
  data,
  toptitle = "",
  ytitle = "",
  monini = 1,
  freq = 12,
  nticks = NULL,
  limits = NULL,
  listexp = c("exp1", "exp2", "exp3"),
  listobs = c("obs1", "obs2", "obs3"),
  biglab = FALSE,
  hlines = NULL,
  drawleg = TRUE,
  leg = NULL,
  siglev = FALSE,
  title_scale = 1,
  sizetit = NULL,
  show_conf = TRUE,
  fileout = NULL,
  width = 8,
  height = 5,
  size_units = "in",
  res = 100,
  var = NULL,
  ...
)
}
\arguments{
\item{data}{Matrix containing any Prediction Score with dimensions:\cr
(nexp/nmod, 3/4 ,nltime)\cr
or (nexp/nmod, nobs, 3/4 ,nltime).}

\item{toptitle}{Main title, optional.}

\item{ytitle}{Title of Y-axis, optional.}

\item{monini}{Starting month between 1 and 12. Default = 1.}

\item{freq}{1 = yearly, 12 = monthly, 4 = seasonal, ... Default = 12.}

\item{nticks}{Number of ticks and labels on the x-axis, optional.}

\item{limits}{c(lower limit, upper limit): limits of the Y-axis, optional.}

\item{listexp}{List of experiment names, optional.}

\item{listobs}{List of observation names, optional.}

\item{biglab}{TRUE/FALSE for presentation/paper plot. Default = FALSE.}

\item{hlines}{c(a,b, ..) Add horizontal black lines at Y-positions a,b, ...\cr
Default = NULL.}

\item{drawleg}{TRUE/FALSE if legend should be added or not to the plot. 
Default = TRUE.}

\item{leg}{Deprecated. Use 'drawleg' instead.}

\item{siglev}{TRUE/FALSE if significance level should replace confidence 
interval.\cr
Default = FALSE.}

\item{title_scale}{Scale factor for the figure top title. Defaults to 1.}

\item{sizetit}{Deprecated. Use 'title_scale' instead.}

\item{show_conf}{TRUE/FALSE to show/not confidence intervals for input 
variables.}

\item{fileout}{Name of output file. Extensions allowed: eps/ps, jpeg, png, 
pdf, bmp and tiff. The default value is NULL.}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of the 
corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{var}{Deprecated. Use 'data' instead.}

\item{...}{Arguments to be passed to the method. Only accepts the following
graphical parameters:\cr
adj ann ask bg bty cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg fig font font.axis font.lab font.main font.sub 
lheight ljoin lmitre mar mex mfcol mfrow mfg mkh oma omd omi page pch plt 
smo srt tck tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog \cr
For more information about the parameters see `par`.}
}
\value{
A figure in popup window by default, or saved to the specified path
 via \code{fileout}.
}
\description{
Plot the correlation (\code{Corr()}), the root mean square error 
(\code{RMS()}) between the forecast values and their observational 
counterpart, the slope of their trend (\code{Trend()}), the 
InterQuartile range, maximum-mininum, standard deviation or median absolute 
Deviation of the ensemble members (\code{Spread()}), or the ratio between 
the ensemble spread and the RMSE of the ensemble mean (\code{RatioSDRMS()}) 
along the forecast time for all the input experiments on the same figure 
with their confidence intervals.
}
\details{
Examples of input:\cr
Model and observed output from \code{Load()} then \code{Clim()} then 
\code{Ano()} then \code{Smoothing()}:\cr
(nmod, nmemb, nsdate, nltime) and (nobs, nmemb, nsdate, nltime)\cr
then averaged over the members\cr
\code{Mean1Dim(var_exp/var_obs, posdim = 2)}:\cr
(nmod, nsdate, nltime) and (nobs, nsdate, nltime)\cr
then passed through\cr
  \code{Corr(exp, obs, posloop = 1, poscor = 2)} or\cr
  \code{RMS(exp, obs, posloop = 1, posRMS = 2)}:\cr
  (nmod, nobs, 3, nltime)\cr
would plot the correlations or RMS between each exp & each obs as a function 
of the forecast time.
}
\examples{
clim <- s2dv::Clim(ts_temp$exp, ts_temp$obs, time_dim = "sdate",
                   dat_dim = c("dat", "member"))
ano_exp <- s2dv::Ano(ts_temp$exp, clim$clim_exp)
ano_obs <- s2dv::Ano(ts_temp$obs, clim$clim_obs)
corr_ano <- s2dv::Corr(s2dv::MeanDims(ano_exp, 'member'), ano_obs,
                       time_dim = 'sdate', dat_dim = 'dat')
input_cor <- array(dim = c(dat = 1, 4, time = 5))
input_cor[, 1, ] <- corr_ano$conf.lower[, 1, 1, ]
input_cor[, 2, ] <- corr_ano$corr[, 1, 1, ]
input_cor[, 3, ] <- corr_ano$conf.upper[, 1, 1, ]
input_cor[, 4, ] <- corr_ano$p.val[, 1, 1, ]
VizVsLTime(input_cor, toptitle = "Correlation",
           monini = 11, limits = c(-1, 2), listexp = 'SEAS5', 
           listobs = 'ERA5', biglab = FALSE, hlines = c(-1, 0, 1))

}
