% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_tests.R
\name{wilcoxon_test}
\alias{wilcoxon_test}
\title{An event study Wilcoxon signed rank test.}
\usage{
wilcoxon_test(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item \code{wlcx_stat}: a Wilcoxon signed rank test statistic
    \item \code{wlcx_signif}: a significance of the statistic
}
}
\description{
Performs Wilcoxon test on the event period for abnormal returns
(abnormal returns are considered as differences).
}
\details{
The estimation periods can overlap with event windows, because the procedure
takes into account only abnormal returns from the event window. The test has
the same algorithm as built-in \code{R} \code{\link{wilcox.test}}. The
critical values are exact values, which are obtained from
\code{\link{qsignrank}}. The algorithm is the following: for each day in
event window the cross-sectional abnormal returns treated as sample of
differences. Firstly the absolute value of these differences are computed,
and corresponding ranks of non-zero values are calculated. The test statistic
is the sum of ranks, corresponding to positive abnormal returns. The
significance levels of \eqn{\alpha} are 0.1, 0.05, and 0.01 (marked
respectively by *, **, and ***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^STOXX50E",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "RSA.L", "TOP.CO")
get_prices_from_tickers(tickers,
                        start = as.Date("2000-01-01"),
                        end = as.Date("2002-01-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    wilcoxon_test(event_start = as.Date("2001-09-11"),
                  event_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
wilcoxon_test(list_of_returns = securities_returns,
              event_start =  as.Date("2001-09-11"),
              event_end = as.Date("2001-09-28"))

}
\references{
\itemize{
\item Wilcoxon F. \emph{Individual Comparisons by Ranking Methods}.
Biometrics Bulletin 1(6):80-83, 1945.
\item Kolari J.W., Pynnonen S. \emph{Event Study Testing with Cross-sectional
Correlation of Abnormal Returns}. The Review of Financial Studies,
23(11):3996-4025, 2010.
\item Lehmann E.L, \emph{Nonparametrics: Statistical Methods Based on Ranks}.
San Francisco: Holden-Day, 1975.
\item Hollander M., Wolfe D.A. \emph{Nonparametric Statistical Methods}.
New York: John Wiley & Sons, 1973.
}
}
\seealso{
\code{\link{nonparametric_tests}}, \code{\link{sign_test}},
\code{\link{generalized_sign_test}}, \code{\link{corrado_sign_test}},
\code{\link{rank_test}}, and \code{\link{modified_rank_test}}.
}
