% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car_nonparametric_tests.R
\name{car_rank_test}
\alias{car_rank_test}
\title{Cowan's CAR test.}
\usage{
car_rank_test(list_of_returns, car_start, car_end, percentage = 90)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{car_start}{an object of \code{Date} class giving the first date of
the CAR period.}

\item{car_end}{an object of \code{Date} class giving the last date of the
CAR period.}

\item{percentage}{a lowest allowed percentage of non-missing observation
for each day to be incorporated into CAR. The default value is 90 percent.
\itemize{
    \item \code{name}: a name of the test, i.e.
    \code{"car_brown_warner_1985"}
    \item \code{car_start}: the first date of the CAR period
    \item \code{car_end}: the last date of the CAR period
    \item \code{average_percentage}: an average share of non-missing
          observations over the CAR period
    \item \code{statistic}: a test's statistic
    \item \code{number_of_days}: the number of days in the CAR period
    \item \code{significance}: a significance of the statistic
}}
}
\description{
A nonparametric test proposed by Cowan 1992 as an extension of the rank test
 proposed by Corrado 1989.
}
\details{
This function performs a test proposed by Cowan 1992 to investigate the
significance of the CAR for a given period. In order to get ranks of
corresponding abnormal returns, the procedure uses regular R function
\code{\link{rank}} with parameter \code{ties.method = "average"} and
\code{na.last = "keep"}. For this test the estimation period and the event
period must not overlap, otherwise an error will be thrown. The test
statistic is assumed to have a normal distribution (as an approximation). The
 test is well-specified for the case, when cross-sectional abnormal returns
are not symmetric. The test is stable to variance increase during given
period. This test ignores the dependence of abnormal returns' ranks of
different days (i.e., a serial dependence). The critical values are standard
normal. The significance levels of \eqn{\alpha} are 0.1, 0.05, and 0.01
(marked respectively by *, **, and ***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^STOXX50E",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "RSA.L", "TOP.CO")
get_prices_from_tickers(tickers,
                        start = as.Date("2000-01-01"),
                        end = as.Date("2002-01-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    car_rank_test(car_start = as.Date("2001-09-11"),
                  car_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
car_rank_test(
    list_of_returns = securities_returns,
    car_start = as.Date("2001-09-11"),
    car_end = as.Date("2001-09-28")
)

}
\references{
\itemize{
\item Corrado C.J. \emph{A Nonparametric Test for Abnormal Security-Price
Performance in Event Studies}. Journal of Financial Economics 23:385-395,
1989.
\item Cowan A.R. \emph{Nonparametric Event Study Tests}. Review of
Quantitative Finance and Accounting, 2:343-358, 1992.
}
}
\seealso{
\code{\link{car_nonparametric_tests}}.
}
