% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sddf_cntrounds.R
\name{show_sddf_cntrounds}
\alias{show_sddf_cntrounds}
\title{Return available SDDF rounds for a country in the European Social Survey}
\usage{
show_sddf_cntrounds(country, ess_email = NULL)
}
\arguments{
\item{country}{A character of length 1 with the full name of the country.
Use \code{\link{show_countries}} for a list of available countries.}

\item{ess_email}{a character vector with your email, such as "your_email@email.com".
If you haven't registered in the ESS website, create an account at 
\url{http://www.europeansocialsurvey.org/user/new}. A preferred method is to login
through \code{\link{set_email}}.}
}
\value{
numeric vector with available rounds for \code{country}
}
\description{
Return available SDDF rounds for a country in the European Social Survey
}
\details{
SDDF data are the equivalent weight data used to analyze the European Social Survey
properly. For more information, see the details section of \code{\link{import_sddf_country}}.
As an exception to the \code{show_*} family of functions, \code{show_sddf rounds}
needs your ESS email to check which rounds are available. Be sure to add it
with \code{\link{set_email}}.
}
\examples{

\dontrun{
set_email("your_email@email.com")

show_sddf_cntrounds("Spain")
}

}
