% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_obj_data.R
\name{load.obj.data}
\alias{load.obj.data}
\title{Load data of an \pkg{espadon} class object}
\usage{
load.obj.data(obj, tag.dictionary = dicom.tag.dictionary())
}
\arguments{
\item{obj}{\code{struct} or "volume" class object}

\item{tag.dictionary}{Dataframe, by default equal to
\link[espadon]{dicom.tag.dictionary}, whose structure it must keep.
This dataframe is used to parse DICOM files in case obj was extracted from DICOM files.}
}
\value{
Returns the \pkg{espadon} object with data \code{$vol3D.data} or {$roi.data}
}
\description{
The \code{load.obj.data} function loads all the data of an \pkg{espadon}
object of class '\code{struct}' or '\code{volume}'.
}
\examples{
# First, save toy patient objects to a temporary file pat.dir for testing.
pat.dir <- file.path (tempdir(), "PM_Rdcm") 
dir.create (pat.dir, recursive = TRUE) 
patient <- toy.load.patient (modality = c("ct", "mr"), roi.name = "", 
                             dxyz = c (4, 4, 4))
save.to.Rdcm (patient$ct[[1]], dirname = pat.dir)
rm( patient)


patient <- load.patient.from.Rdcm (pat.dir, data = FALSE)
CT <- load.obj.data (patient$ct[[1]])
str (CT, max.level = 2)
}
\seealso{
\link[espadon]{load.obj.from.dicom} and \link[espadon]{load.obj.from.Rdcm}
}
