% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histo_2D.R
\name{histo.2D}
\alias{histo.2D}
\title{2D histograms of 2 volumes}
\usage{
histo.2D(
  x.vol,
  y.vol,
  x.breaks = NULL,
  y.breaks = NULL,
  include.outer = TRUE,
  alias = "",
  description = ""
)
}
\arguments{
\item{x.vol, y.vol}{"volume" class objects. The 2 volumes must have the
grid (i.e. share the same voxels location).}

\item{x.breaks, y.breaks}{Vectors giving the breakpoints of x and y axes. See
Details.}

\item{include.outer}{Boolean. If \code{include.outer = TRUE}, the values out
the \code{x.breaks} and \code{y.breaks} of each volume are counted in the first
and the last cell of the histograms. They are not taken into account otherwise.}

\item{alias}{Character string, \code{$alias} of the created object}

\item{description}{Character string, describing the created object.}
}
\value{
Returns a "histo2D" class object. This is a list including:
\itemize{
\item \code{$patient}: set to \code{x.vol$patient}.
\item \code{$patient.bd}: set to \code{x.vol$patient.bd}.
\item \code{$patient.sex}: set to \code{x.vol$patient.sex}.
\item \code{$file.basename}: set to "".
\item \code{$file.dirname}: set to "".
\item \code{$object.name}: set to "".
\item \code{$object.alias}: alias of the histo2D object.
\item \code{$frame.of.reference}: set to \code{x.vol$frame.of.reference}.
\item \code{$ref.pseudo} : set to \code{x.vol$ref.pseudo}.
\item \code{$modality} : set to \code{"histo2D"}.
\item \code{$description}: description of the histo2D object.
\item \code{$creation.date}: set to \code{Sys.Date}.
\item \code{$nb.pixels}: number of elements in the \code{density.map}.
\item \code{$x.file.src}: set to x.vol$object.alias
\item \code{$y.file.src}: set to y.vol$object.alias
\item \code{x.breaks}: vector of x-axis breakpoints.
\item \code{y.breaks}: vector of y-axis breakpoints.
\item \code{x.mids}: vector of x-axis cell centers.
\item \code{y.mids}: vector of y-axis cell centers.
\item \code{density.map}: array of densities.
\item \code{total.counts}: number of counted voxels.
}
}
\description{
The \code{histo.2D} function creates a "histo2D" class object,
containing the two-dimensional array of histograms of two "volume" class
objects  that have the same grid.
}
\details{
The arguments \code{x.breaks} and \code{y.breaks} represent the scales
of the x and y axes of 2D-histogram graph. If they are \code{NULL}, the
\code{histo.2D} function defaults to 256 cells between the values
\code{vol$min.pixel} and \code{vol$max.pixel}.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "mr", "rtstruct"), 
                             roi.name =  "brain", 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
MR <- patient$mr[[1]]
S <- patient$rtstruct[[1]]
T.MAT <- patient$T.MAT

# restriction of the volume around the RoI
CT.on.roi <- nesting.roi (CT, S, roi.name = "brain", vol.restrict = TRUE,
                          xyz.margin = c (1, 1, 1), alias = CT$description)
MR.on.CT <- vol.regrid (vol = MR, back.vol = CT.on.roi, interpolate = TRUE,
                        T.MAT = T.MAT, alias = CT$description,
                        description = NULL)
# selection of voxels included in the RoI.
roi.bin <- bin.from.roi (vol = CT.on.roi, struct = S, roi.sname = "brain")
MR.select <- vol.from.bin (MR.on.CT, roi.bin, alias = MR$description)
CT.select <- vol.from.bin (CT.on.roi, roi.bin, alias = CT$description)
# 2D histogram
H2D <- histo.2D (MR.select, CT.select, x.breaks = seq (50, 400, 10),
			  y.breaks = seq (50, 400, 10), alias = "H2D MR CT")
str (H2D)
}
\seealso{
\link[espadon]{display.2D.histo}.
}
