% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_filter.R
\name{signal_filter}
\alias{signal_filter}
\title{Filter a seismic signal in the time or frequency domain}
\usage{
signal_filter(
  data,
  f,
  fft = FALSE,
  dt,
  type,
  shape = "butter",
  order = 2,
  p = 0,
  lazy = FALSE
)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{f}{\code{Numeric} value or vector of length two, lower and/or 
upper cutoff frequencies (Hz).}

\item{fft}{\code{Logical} value, option to filter in the time domain 
(\code{fft = FALSE}) or the frequency domain (\code{fft = TRUE}). Default 
is (\code{fft = FALSE}).}

\item{dt}{\code{Numeric} value, sampling period. If omitted, \code{dt} 
is set to 1/200.}

\item{type}{\code{Character} value, type of filter, one out of 
\code{"LP"} (low pass), \code{"HP"} (high pass), \code{"BP"} (band 
pass) and \code{"BR"} (band rejection). If omitted, the type is interpreted 
from \code{f}. If \code{f} is of length two, \code{type} is set to 
\code{"BP"}. If \code{f} is of length one, \code{type} is set to 
\code{"HP"}.}

\item{shape}{\code{Character} value, one out of \code{"butter"} 
(Butterworth), default is \code{"butter"}.}

\item{order}{\code{Numeric} value, order of the filter, default 
is \code{2}. Only needed if \code{data} is no \code{eseis} object.}

\item{p}{\code{Numeric} value, fraction of the signal to be tapered.}

\item{lazy}{\code{Logical} value, option to pre- and post-process data, 
including detrending, demeaning and tapering (\code{p = 0.02}). Default 
if \code{FALSE}.}
}
\value{
\code{Numeric} vector or list of vectors, filtered signal vector.
}
\description{
The function filters the input signal vector in the time or
frequency domain.
}
\examples{

## load example data set
data(rockfall)

## filter data set by bandpass filter between 1 and 90 Hz
rockfall_bp <- signal_filter(data = rockfall_eseis, 
                             f = c(1, 90))
                             
## taper signal to account for edge effects
rockfall_bp <- signal_taper(data = rockfall_bp, 
                            n = 2000)

## plot filtered signal
plot_signal(data = rockfall_bp)

## compare time domain versus frequency domain filtering
rockfall_td <- signal_filter(data = rockfall_eseis, 
                             f = c(10, 40), 
                             fft = FALSE)
                             
rockfall_td_sp <- signal_spectrum(data = rockfall_td)

rockfall_fd <- signal_filter(data = rockfall_eseis, 
                             f = c(10, 40), 
                             fft = TRUE)
                             
rockfall_fd_sp <- signal_spectrum(data = rockfall_fd)

plot_spectrum(data = rockfall_td_sp)
plot_spectrum(data = rockfall_fd_sp)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
