% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_detrend.R
\name{signal_detrend}
\alias{signal_detrend}
\title{Detrend a signal vector.}
\usage{
signal_detrend(data)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}
}
\value{
\code{Numeric} vector or list of vectors, detrended data set.
}
\description{
The function removes a linear trend from a signal vector.
}
\examples{

## load example data set
data(rockfall)

## remove linear trend from data set
rockfall_detrend <- signal_detrend(data = rockfall_eseis)

## compare data ranges
range(rockfall_eseis$signal)
range(rockfall_detrend$signal)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
