% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview.R
\name{overview}
\alias{overview}
\title{Calculates descriptive statistics for a continuous variable}
\usage{
overview(
  data = NULL,
  outcome_variable = NULL,
  grouping_variable = NULL,
  means = NULL,
  sds = NULL,
  ns = NULL,
  grouping_variable_levels = NULL,
  outcome_variable_name = "My Outcome Variable",
  grouping_variable_name = NULL,
  conf_level = 0.95,
  assume_equal_variance = FALSE
)
}
\arguments{
\item{data}{\itemize{
\item for raw data, a data frame or tibble
}}

\item{outcome_variable}{\itemize{
\item for raw data, either a vector containing numerical
data or the name of a data-frame column containing a factor
}}

\item{grouping_variable}{\itemize{
\item optional; for raw data either a vector containing
a factor or the name of a data frame column containing a factor
}}

\item{means}{For summary data - A vector of 1 or more numerical means}

\item{sds}{For summary data - A vector of standard deviations, same length as
means}

\item{ns}{For summary data - A vector of sample sizes, same length as means}

\item{grouping_variable_levels}{For summary data - An optional vector of
group labels, same length as means.  If not passed, auto-generated.}

\item{outcome_variable_name}{Optional friendly name for the outcome variable.
Defaults to 'My Outcome Variable'.  Ignored if a data-frame is passed,
this argument is ignored.}

\item{grouping_variable_name}{Optional friendly name for the grouping
variable.  If a data frame is passed, this argument is ignored.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{assume_equal_variance}{Defaults to FALSE}
}
\value{
Returns a table of descriptive statistics
\itemize{
\item \strong{overview}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{grouping_variable_name} -
\item \emph{grouping_variable_level} -
\item \emph{mean} -
\item \emph{mean_LL} -
\item \emph{mean_UL} -
\item \emph{median} -
\item \emph{median_LL} -
\item \emph{median_UL} -
\item \emph{sd} -
\item \emph{min} -
\item \emph{max} -
\item \emph{q1} -
\item \emph{q3} -
\item \emph{n} -
\item \emph{missing} -
\item \emph{df} -
\item \emph{mean_SE} -
\item \emph{median_SE} -
}
}
}
\description{
This function calculates basic descriptive statistics for a numerical
variable.  It can calculate an overall summary, or broken down by
the levels of a grouping variable.  Inputs can be summary data,
vectors, or a data frame.
}
\details{
If equal variance is not assumed, each group is treated independently.  In
that case, the estimated mean, CI, and SE is from \code{\link[statpsych:ci.mean1]{statpsych::ci.mean1()}},
and the estimated median, CI, and SE is from \code{\link[statpsych:ci.median1]{statpsych::ci.median1()}}.  If
equal variance is assumed, each group CI is calculated as with respect to all
group data, using \code{\link[statpsych:ci.lc.mean.bs]{statpsych::ci.lc.mean.bs()}} and
\code{\link[statpsych:ci.lc.median.bs]{statpsych::ci.lc.median.bs()}}
}
\examples{
# example code
esci::overview(data_latimier_3groups, "Test\%", "Group")


}
