% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlated_patient_sample.R
\name{CorrelatedPatientSample}
\alias{CorrelatedPatientSample}
\title{A sample of patients that experience correlated events in simulations.}
\description{
Class to house the latent random variables that govern toxicity and efficacy
events in patients. Instances of this class can be used in simulation-like
tasks to effectively use the same simulated individuals in different designs,
thus supporting reduced Monte Carlo error and more efficient comparison. This
class differs from \code{\link{PatientSample}} in that the latent variables
that underlie efficacy and toxicity events, and therefore those events
themselves, are correlated, e.g. for positive association, a patient that
experiences toxicity has increased probability of experiencing efficacy too.
Correlated uniformly-distributed variables are obtained by inverting
bivariate normal variables. The extent to which the events are correlated is
controlled by rho, the correlation of the two normal variables.
}
\references{
Sweeting, M., Slade, D., Jackson, D., & Brock, K. (2024).
Potential outcome simulation for efficient head-to-head comparison of
adaptive dose-finding designs. arXiv preprint arXiv:2402.15460
}
\section{Super class}{
\code{\link[escalation:PatientSample]{escalation::PatientSample}} -> \code{CorrelatedPatientSample}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{num_patients}}{(`integer(1)`)\cr}

\item{\code{mu}}{(`numeric(2)`)\cr}

\item{\code{sigma}}{(`matrix(2, 2)`)\cr}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CorrelatedPatientSample-new}{\code{CorrelatedPatientSample$new()}}
\item \href{#method-CorrelatedPatientSample-expand_to}{\code{CorrelatedPatientSample$expand_to()}}
\item \href{#method-CorrelatedPatientSample-clone}{\code{CorrelatedPatientSample$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="escalation" data-topic="PatientSample" data-id="get_eff_u"><a href='../../escalation/html/PatientSample.html#method-PatientSample-get_eff_u'><code>escalation::PatientSample$get_eff_u()</code></a></span></li>
<li><span class="pkg-link" data-pkg="escalation" data-topic="PatientSample" data-id="get_patient_eff"><a href='../../escalation/html/PatientSample.html#method-PatientSample-get_patient_eff'><code>escalation::PatientSample$get_patient_eff()</code></a></span></li>
<li><span class="pkg-link" data-pkg="escalation" data-topic="PatientSample" data-id="get_patient_tox"><a href='../../escalation/html/PatientSample.html#method-PatientSample-get_patient_tox'><code>escalation::PatientSample$get_patient_tox()</code></a></span></li>
<li><span class="pkg-link" data-pkg="escalation" data-topic="PatientSample" data-id="get_tox_u"><a href='../../escalation/html/PatientSample.html#method-PatientSample-get_tox_u'><code>escalation::PatientSample$get_tox_u()</code></a></span></li>
<li><span class="pkg-link" data-pkg="escalation" data-topic="PatientSample" data-id="set_eff_and_tox"><a href='../../escalation/html/PatientSample.html#method-PatientSample-set_eff_and_tox'><code>escalation::PatientSample$set_eff_and_tox()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CorrelatedPatientSample-new"></a>}}
\if{latex}{\out{\hypertarget{method-CorrelatedPatientSample-new}{}}}
\subsection{Method \code{new()}}{
Creator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CorrelatedPatientSample$new(num_patients = 0, rho = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_patients}}{(`integer(1)`).}

\item{\code{rho}}{(`integer(1)`) correlation of}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[CorrelatedPatientSample].
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CorrelatedPatientSample-expand_to"></a>}}
\if{latex}{\out{\hypertarget{method-CorrelatedPatientSample-expand_to}{}}}
\subsection{Method \code{expand_to()}}{
Expand sample to size at least num_patients
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CorrelatedPatientSample$expand_to(num_patients)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_patients}}{(`integer(1)`).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CorrelatedPatientSample-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CorrelatedPatientSample-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CorrelatedPatientSample$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
