% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enforce_three_plus_three.R
\name{enforce_three_plus_three}
\alias{enforce_three_plus_three}
\title{Enforce that a trial path has followed the 3+3 method.}
\usage{
enforce_three_plus_three(outcomes, allow_deescalate = FALSE)
}
\arguments{
\item{outcomes}{Outcomes observed. See \code{\link{parse_phase1_outcomes}}.}

\item{allow_deescalate}{TRUE to allow de-escalation, as described by Korn et
al. Default is FALSE.}
}
\value{
Nothing. Function stops if problem detected.
}
\description{
This function stops with en error if it detects that outcomes describing  a
trial path have diverged from that advocated by the 3+3 method.
}
\examples{
\dontrun{
enforce_three_plus_three('1NNN 2NTN 2NNN')  # OK
enforce_three_plus_three('1NNN 2NTN 2N')  # OK too, albeit in-progress cohort
enforce_three_plus_three('1NNN 1N')  # Not OK because should have escalated
}
}
